<?php

namespace App\Models {

    /**
     * App\Models\Client
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $total_consultations
     * @property \Illuminate\Support\Carbon|null $verified_at
     * @property mixed $verification_status
     * @property string $pincode
     * @property string $state
     * @property string $city
     * @property string|null $address
     * @property string|null $clinic_hospital_name
     * @property string|null $medical_license
     * @property mixed $profession_type
     * @property int $user_id
     * @property int $id
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Consultation> $consultations
     * @property-read int|null $consultations_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Payment> $payments
     * @property-read int|null $payments_count
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereProfessionType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereMedicalLicense($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereClinicHospitalName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereCity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereState($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client wherePincode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereVerificationStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereTotalConsultations($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client verified()
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Client>|Client query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Client extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Commission
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property \Illuminate\Support\Carbon|null $processed_at
     * @property mixed $status
     * @property decimal:2 $gst_amount
     * @property decimal:2 $platform_fee
     * @property decimal:2 $professional_earning
     * @property decimal:2 $platform_commission
     * @property int $commission_percentage
     * @property decimal:2 $consultation_fee
     * @property int $professional_id
     * @property int $consultation_id
     * @property int $id
     * @property-read \App\Models\Consultation $consultation
     * @property-read \App\Models\Professional $professional
     * @property-read \App\Models\Payout $payout
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereConsultationId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereProfessionalId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereConsultationFee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereCommissionPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission wherePlatformCommission($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereProfessionalEarning($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission wherePlatformFee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereGstAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereProcessedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission pending()
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission completed()
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Commission>|Commission query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Commission extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Consultation
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int|null $cancelled_by
     * @property string|null $cancellation_reason
     * @property \Illuminate\Support\Carbon|null $cancelled_at
     * @property string|null $invoice_number
     * @property array|null $documents
     * @property string|null $client_notes
     * @property string|null $consultation_notes
     * @property string|null $meeting_url
     * @property string|null $meeting_id
     * @property decimal:2 $total_amount
     * @property decimal:2 $gst_amount
     * @property decimal:2 $platform_fee
     * @property decimal:2 $consultation_fee
     * @property mixed $status
     * @property int|null $duration_minutes
     * @property \Illuminate\Support\Carbon|null $ended_at
     * @property \Illuminate\Support\Carbon|null $started_at
     * @property \Illuminate\Support\Carbon $scheduled_at
     * @property mixed $consultation_type
     * @property int $professional_id
     * @property int $client_id
     * @property string $consultation_id
     * @property int $id
     * @property-read \App\Models\Client $client
     * @property-read \App\Models\Professional $professional
     * @property-read \App\Models\Payment $payment
     * @property-read \App\Models\Commission $commission
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Review> $reviews
     * @property-read int|null $reviews_count
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereConsultationId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereClientId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereProfessionalId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereConsultationType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereScheduledAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereStartedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereEndedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereDurationMinutes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereConsultationFee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation wherePlatformFee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereGstAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereMeetingId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereMeetingUrl($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereConsultationNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereClientNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereDocuments($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereInvoiceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereCancelledAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereCancellationReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereCancelledBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Consultation>|Consultation query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Consultation extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Payment
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $refund_reason
     * @property decimal:2|null $refund_amount
     * @property \Illuminate\Support\Carbon|null $refunded_at
     * @property \Illuminate\Support\Carbon|null $paid_at
     * @property string|null $invoice_number
     * @property array|null $gateway_response
     * @property string|null $gateway_order_id
     * @property string|null $gateway_payment_id
     * @property mixed $payment_gateway
     * @property mixed $status
     * @property string $currency
     * @property decimal:2 $total_amount
     * @property decimal:2 $gst_amount
     * @property decimal:2 $amount
     * @property mixed $payment_type
     * @property int $payable_id
     * @property string $payable_type
     * @property int $user_id
     * @property string $payment_id
     * @property int $id
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Payment $payable
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment wherePaymentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment wherePayableType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment wherePayableId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment wherePaymentType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereGstAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereTotalAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment wherePaymentGateway($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereGatewayPaymentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereGatewayOrderId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereGatewayResponse($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereInvoiceNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment wherePaidAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereRefundedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereRefundAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereRefundReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment completed()
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment pending()
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Payment>|Payment query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Payment extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Payout
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $commission_ids
     * @property int|null $processed_by
     * @property string|null $notes
     * @property string|null $transaction_reference
     * @property string $account_holder_name
     * @property string $bank_name
     * @property string $bank_ifsc
     * @property string $bank_account_number
     * @property \Illuminate\Support\Carbon|null $processed_date
     * @property \Illuminate\Support\Carbon $request_date
     * @property mixed $status
     * @property decimal:2 $net_amount
     * @property decimal:2 $tds_amount
     * @property decimal:2 $amount
     * @property int $professional_id
     * @property string $payout_id
     * @property int $id
     * @property-read \App\Models\Professional $professional
     * @property-read \App\Models\User $processedBy
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout wherePayoutId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereProfessionalId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereTdsAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereNetAmount($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereRequestDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereProcessedDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereBankAccountNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereBankIfsc($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereBankName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereAccountHolderName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereTransactionReference($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereNotes($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereProcessedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereCommissionIds($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout pending()
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout completed()
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Payout>|Payout query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Payout extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Professional
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $total_consultations
     * @property decimal:2 $rating
     * @property boolean $is_featured
     * @property string|null $rejection_reason
     * @property int|null $verified_by
     * @property \Illuminate\Support\Carbon|null $verified_at
     * @property mixed $verification_status
     * @property array|null $documents
     * @property string $pincode
     * @property string $state
     * @property string $city
     * @property string|null $office_address
     * @property array|null $availability
     * @property decimal:2 $consultation_fee
     * @property int $experience_years
     * @property array|null $specializations
     * @property \Illuminate\Support\Carbon|null $license_expiry
     * @property string|null $registration_body
     * @property string|null $membership_id
     * @property string $license_number
     * @property mixed $profession_type
     * @property int $user_id
     * @property int $id
     * @property-read \App\Models\User $user
     * @property-read \App\Models\Subscription $activeSubscription
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Subscription> $subscriptions
     * @property-read int|null $subscriptions_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Consultation> $consultations
     * @property-read int|null $consultations_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Commission> $commissions
     * @property-read int|null $commissions_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Payout> $payouts
     * @property-read int|null $payouts_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Review> $reviews
     * @property-read int|null $reviews_count
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereProfessionType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereLicenseNumber($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereMembershipId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereRegistrationBody($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereLicenseExpiry($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereSpecializations($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereExperienceYears($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereConsultationFee($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereAvailability($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereOfficeAddress($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereCity($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereState($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional wherePincode($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereDocuments($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereVerificationStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereVerifiedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereRejectionReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereIsFeatured($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereRating($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereTotalConsultations($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional verified()
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional featured()
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Professional>|Professional query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Professional extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Review
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $flag_reason
     * @property boolean $is_flagged
     * @property \Illuminate\Support\Carbon|null $approved_at
     * @property int|null $approved_by
     * @property boolean $approved_by_admin
     * @property array|null $criteria_ratings
     * @property string|null $comment
     * @property mixed $status
     * @property int $rating
     * @property mixed $role_from
     * @property int $to_user_id
     * @property int $from_user_id
     * @property int $consultation_id
     * @property int $id
     * @property-read \App\Models\Consultation $consultation
     * @property-read \App\Models\User $fromUser
     * @property-read \App\Models\User $toUser
     * @property-read \App\Models\User $approvedBy
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereConsultationId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereFromUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereToUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereRoleFrom($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereRating($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereComment($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereCriteriaRatings($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereApprovedByAdmin($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereApprovedBy($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereApprovedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereIsFlagged($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereFlagReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review approved()
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review pending()
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review fromClients()
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review fromProfessionals()
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Review>|Review query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Review extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Subscription
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $auto_renew
     * @property string|null $cancellation_reason
     * @property \Illuminate\Support\Carbon|null $cancelled_at
     * @property array|null $payment_details
     * @property string|null $payment_id
     * @property mixed $status
     * @property \Illuminate\Support\Carbon $end_date
     * @property \Illuminate\Support\Carbon $start_date
     * @property decimal:2 $amount_paid
     * @property mixed $billing_cycle
     * @property int $subscription_plan_id
     * @property int $professional_id
     * @property int $id
     * @property-read \App\Models\Professional $professional
     * @property-read \App\Models\SubscriptionPlan $subscriptionPlan
     * @property-read \App\Models\Payment $payment
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereProfessionalId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereSubscriptionPlanId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereBillingCycle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereAmountPaid($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereStartDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereEndDate($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription wherePaymentId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription wherePaymentDetails($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereCancelledAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereCancellationReason($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereAutoRenew($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription active()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription expired()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscription>|Subscription query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Subscription extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\SubscriptionPlan
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $sort_order
     * @property boolean $is_active
     * @property boolean $dedicated_support
     * @property boolean $featured_profile
     * @property boolean $priority_listing
     * @property int|null $max_consultations_per_month
     * @property array|null $features
     * @property int $commission_percentage
     * @property decimal:2 $yearly_price
     * @property decimal:2 $monthly_price
     * @property string|null $description
     * @property string $slug
     * @property string $name
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Subscription> $subscriptions
     * @property-read int|null $subscriptions_count
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereMonthlyPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereYearlyPrice($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereCommissionPercentage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereFeatures($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereMaxConsultationsPerMonth($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan wherePriorityListing($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereFeaturedProfile($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereDedicatedSupport($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereIsActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereSortOrder($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan active()
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan bySlug()
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<SubscriptionPlan>|SubscriptionPlan query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class SubscriptionPlan extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\User
     *
     * @property string|null $remember_token
     * @property \Illuminate\Support\Carbon|null $deleted_at
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $bio
     * @property string|null $profile_image
     * @property mixed $status
     * @property mixed $user_type
     * @property string|null $phone
     * @property string $password
     * @property \Illuminate\Support\Carbon|null $email_verified_at
     * @property string $email
     * @property string $name
     * @property int $id
     * @property-read \App\Models\Professional $professional
     * @property-read \App\Models\Client $client
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Consultation> $clientConsultations
     * @property-read int|null $clientConsultations_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Consultation> $professionalConsultations
     * @property-read int|null $professionalConsultations_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Review> $reviewsGiven
     * @property-read int|null $reviewsGiven_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Review> $reviewsReceived
     * @property-read int|null $reviewsReceived_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
     * @property-read int|null $notifications_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Laravel\Sanctum\PersonalAccessToken> $tokens
     * @property-read int|null $tokens_count
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePhone($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUserType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereProfileImage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBio($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDeletedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
     * @method static mixed select($columns)
     * @method static mixed selectSub($query, $as)
     * @method static mixed selectRaw($expression, array $bindings)
     * @method static mixed fromSub($query, $as)
     * @method static mixed fromRaw($expression, $bindings)
     * @method static mixed createSub($query)
     * @method static mixed parseSub($query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
     * @method static mixed addSelect($column)
     * @method static mixed distinct()
     * @method static mixed from($table, $as)
     * @method static mixed useIndex($index)
     * @method static mixed forceIndex($index)
     * @method static mixed ignoreIndex($index)
     * @method static mixed join($table, $first, $operator, $second, $type, $where)
     * @method static mixed joinWhere($table, $first, $operator, $second, $type)
     * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
     * @method static mixed joinLateral($query, string $as, string $type)
     * @method static mixed leftJoinLateral($query, string $as)
     * @method static mixed leftJoin($table, $first, $operator, $second)
     * @method static mixed leftJoinWhere($table, $first, $operator, $second)
     * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed rightJoin($table, $first, $operator, $second)
     * @method static mixed rightJoinWhere($table, $first, $operator, $second)
     * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
     * @method static mixed crossJoin($table, $first, $operator, $second)
     * @method static mixed crossJoinSub($query, $as)
     * @method static mixed newJoinClause(self $parentQuery, $type, $table)
     * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
     * @method static mixed mergeWheres($wheres, $bindings)
     * @method static mixed where($column, $operator, $value, $boolean)
     * @method static mixed addArrayOfWheres($column, $boolean, $method)
     * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
     * @method static mixed invalidOperatorAndValue($operator, $value)
     * @method static mixed invalidOperator($operator)
     * @method static mixed isBitwiseOperator($operator)
     * @method static mixed orWhere($column, $operator, $value)
     * @method static mixed whereNot($column, $operator, $value, $boolean)
     * @method static mixed orWhereNot($column, $operator, $value)
     * @method static mixed whereColumn($first, $operator, $second, $boolean)
     * @method static mixed orWhereColumn($first, $operator, $second)
     * @method static mixed whereRaw($sql, $bindings, $boolean)
     * @method static mixed orWhereRaw($sql, $bindings)
     * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
     * @method static mixed orWhereLike($column, $value, $caseSensitive)
     * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
     * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
     * @method static mixed whereIn($column, $values, $boolean, $not)
     * @method static mixed orWhereIn($column, $values)
     * @method static mixed whereNotIn($column, $values, $boolean)
     * @method static mixed orWhereNotIn($column, $values)
     * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
     * @method static mixed orWhereIntegerInRaw($column, $values)
     * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
     * @method static mixed orWhereIntegerNotInRaw($column, $values)
     * @method static mixed whereNull($columns, $boolean, $not)
     * @method static mixed orWhereNull($column)
     * @method static mixed whereNotNull($columns, $boolean)
     * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
     * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
     * @method static mixed orWhereBetween($column, iterable $values)
     * @method static mixed orWhereBetweenColumns($column, array $values)
     * @method static mixed whereNotBetween($column, iterable $values, $boolean)
     * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
     * @method static mixed orWhereNotBetween($column, iterable $values)
     * @method static mixed orWhereNotBetweenColumns($column, array $values)
     * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
     * @method static mixed orWhereValueBetween($value, array $columns)
     * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
     * @method static mixed orWhereValueNotBetween($value, array $columns)
     * @method static mixed orWhereNotNull($column)
     * @method static mixed whereDate($column, $operator, $value, $boolean)
     * @method static mixed orWhereDate($column, $operator, $value)
     * @method static mixed whereTime($column, $operator, $value, $boolean)
     * @method static mixed orWhereTime($column, $operator, $value)
     * @method static mixed whereDay($column, $operator, $value, $boolean)
     * @method static mixed orWhereDay($column, $operator, $value)
     * @method static mixed whereMonth($column, $operator, $value, $boolean)
     * @method static mixed orWhereMonth($column, $operator, $value)
     * @method static mixed whereYear($column, $operator, $value, $boolean)
     * @method static mixed orWhereYear($column, $operator, $value)
     * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
     * @method static mixed whereNested(Closure $callback, $boolean)
     * @method static mixed forNestedWhere()
     * @method static mixed addNestedWhereQuery($query, $boolean)
     * @method static mixed whereSub($column, $operator, $callback, $boolean)
     * @method static mixed whereExists($callback, $boolean, $not)
     * @method static mixed orWhereExists($callback, $not)
     * @method static mixed whereNotExists($callback, $boolean)
     * @method static mixed orWhereNotExists($callback)
     * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
     * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
     * @method static mixed orWhereRowValues($columns, $operator, $values)
     * @method static mixed whereJsonContains($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonContains($column, $value)
     * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntContain($column, $value)
     * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
     * @method static mixed orWhereJsonOverlaps($column, $value)
     * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
     * @method static mixed orWhereJsonDoesntOverlap($column, $value)
     * @method static mixed whereJsonContainsKey($column, $boolean, $not)
     * @method static mixed orWhereJsonContainsKey($column)
     * @method static mixed whereJsonDoesntContainKey($column, $boolean)
     * @method static mixed orWhereJsonDoesntContainKey($column)
     * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
     * @method static mixed orWhereJsonLength($column, $operator, $value)
     * @method static mixed dynamicWhere($method, $parameters)
     * @method static mixed addDynamic($segment, $connector, $parameters, $index)
     * @method static mixed whereFullText($columns, $value, array $options, $boolean)
     * @method static mixed orWhereFullText($columns, $value, array $options)
     * @method static mixed whereAll($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAll($columns, $operator, $value)
     * @method static mixed whereAny($columns, $operator, $value, $boolean)
     * @method static mixed orWhereAny($columns, $operator, $value)
     * @method static mixed whereNone($columns, $operator, $value, $boolean)
     * @method static mixed orWhereNone($columns, $operator, $value)
     * @method static mixed groupBy($groups)
     * @method static mixed groupByRaw($sql, array $bindings)
     * @method static mixed having($column, $operator, $value, $boolean)
     * @method static mixed orHaving($column, $operator, $value)
     * @method static mixed havingNested(Closure $callback, $boolean)
     * @method static mixed addNestedHavingQuery($query, $boolean)
     * @method static mixed havingNull($columns, $boolean, $not)
     * @method static mixed orHavingNull($column)
     * @method static mixed havingNotNull($columns, $boolean)
     * @method static mixed orHavingNotNull($column)
     * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
     * @method static mixed havingRaw($sql, array $bindings, $boolean)
     * @method static mixed orHavingRaw($sql, array $bindings)
     * @method static mixed orderBy($column, $direction)
     * @method static mixed orderByDesc($column)
     * @method static mixed latest($column)
     * @method static mixed oldest($column)
     * @method static mixed inRandomOrder($seed)
     * @method static mixed orderByRaw($sql, $bindings)
     * @method static mixed skip($value)
     * @method static mixed offset($value)
     * @method static mixed take($value)
     * @method static mixed limit($value)
     * @method static mixed groupLimit($value, $column)
     * @method static mixed forPage($page, $perPage)
     * @method static mixed forPageBeforeId($perPage, $lastId, $column)
     * @method static mixed forPageAfterId($perPage, $lastId, $column)
     * @method static mixed reorder($column, $direction)
     * @method static mixed reorderDesc($column)
     * @method static mixed removeExistingOrdersFor($column)
     * @method static mixed union($query, $all)
     * @method static mixed unionAll($query)
     * @method static mixed lock($value)
     * @method static mixed lockForUpdate()
     * @method static mixed sharedLock()
     * @method static mixed beforeQuery(callable $callback)
     * @method static mixed applyBeforeQueryCallbacks()
     * @method static mixed afterQuery(Closure $callback)
     * @method static mixed applyAfterQueryCallbacks($result)
     * @method static mixed toSql()
     * @method static mixed toRawSql()
     * @method static mixed find($id, $columns)
     * @method static mixed findOr($id, $columns, Closure $callback)
     * @method static mixed value($column)
     * @method static mixed rawValue(string $expression, array $bindings)
     * @method static mixed soleValue($column)
     * @method static mixed get($columns)
     * @method static mixed runSelect()
     * @method static mixed withoutGroupLimitKeys($items)
     * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
     * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
     * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
     * @method static mixed ensureOrderForCursorPagination($shouldReverse)
     * @method static mixed getCountForPagination($columns)
     * @method static mixed runPaginationCountQuery($columns)
     * @method static mixed cloneForPaginationCount()
     * @method static mixed withoutSelectAliases(array $columns)
     * @method static mixed cursor()
     * @method static mixed enforceOrderBy()
     * @method static mixed pluck($column, $key)
     * @method static mixed stripTableForPluck($column)
     * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
     * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
     * @method static mixed implode($column, $glue)
     * @method static mixed exists()
     * @method static mixed doesntExist()
     * @method static mixed existsOr(Closure $callback)
     * @method static mixed doesntExistOr(Closure $callback)
     * @method static mixed count($columns)
     * @method static mixed min($column)
     * @method static mixed max($column)
     * @method static mixed sum($column)
     * @method static mixed avg($column)
     * @method static mixed average($column)
     * @method static mixed aggregate($function, $columns)
     * @method static mixed numericAggregate($function, $columns)
     * @method static mixed setAggregate($function, $columns)
     * @method static mixed onceWithColumns($columns, $callback)
     * @method static mixed insert(array $values)
     * @method static mixed insertOrIgnore(array $values)
     * @method static mixed insertGetId(array $values, $sequence)
     * @method static mixed insertUsing(array $columns, $query)
     * @method static mixed insertOrIgnoreUsing(array $columns, $query)
     * @method static mixed update(array $values)
     * @method static mixed updateFrom(array $values)
     * @method static mixed updateOrInsert(array $attributes, callable|array $values)
     * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
     * @method static mixed increment($column, $amount, array $extra)
     * @method static mixed incrementEach(array $columns, array $extra)
     * @method static mixed decrement($column, $amount, array $extra)
     * @method static mixed decrementEach(array $columns, array $extra)
     * @method static mixed delete($id)
     * @method static mixed truncate()
     * @method static mixed newQuery()
     * @method static mixed forSubQuery()
     * @method static mixed getColumns()
     * @method static mixed raw($value)
     * @method static mixed getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static mixed getBindings()
     * @method static mixed getRawBindings()
     * @method static mixed setBindings(array $bindings, $type)
     * @method static mixed addBinding($value, $type)
     * @method static mixed castBinding($value)
     * @method static mixed mergeBindings(self $query)
     * @method static mixed cleanBindings(array $bindings)
     * @method static mixed flattenValue($value)
     * @method static mixed defaultKeyName()
     * @method static mixed getConnection()
     * @method static mixed getProcessor()
     * @method static mixed getGrammar()
     * @method static mixed useWritePdo()
     * @method static mixed isQueryable($value)
     * @method static mixed clone()
     * @method static mixed cloneWithout(array $properties)
     * @method static mixed cloneWithoutBindings(array $except)
     * @method static mixed dump($args)
     * @method static mixed dumpRawSql()
     * @method static mixed dd()
     * @method static mixed ddRawSql()
     * @method static mixed wherePast($columns)
     * @method static mixed whereNowOrPast($columns)
     * @method static mixed orWherePast($columns)
     * @method static mixed orWhereNowOrPast($columns)
     * @method static mixed whereFuture($columns)
     * @method static mixed whereNowOrFuture($columns)
     * @method static mixed orWhereFuture($columns)
     * @method static mixed orWhereNowOrFuture($columns)
     * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
     * @method static mixed whereToday($columns, $boolean)
     * @method static mixed whereBeforeToday($columns)
     * @method static mixed whereTodayOrBefore($columns)
     * @method static mixed whereAfterToday($columns)
     * @method static mixed whereTodayOrAfter($columns)
     * @method static mixed orWhereToday($columns)
     * @method static mixed orWhereBeforeToday($columns)
     * @method static mixed orWhereTodayOrBefore($columns)
     * @method static mixed orWhereAfterToday($columns)
     * @method static mixed orWhereTodayOrAfter($columns)
     * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
     * @method static mixed chunk($count, callable $callback)
     * @method static mixed chunkMap(callable $callback, $count)
     * @method static mixed each(callable $callback, $count)
     * @method static mixed chunkById($count, callable $callback, $column, $alias)
     * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
     * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
     * @method static mixed eachById(callable $callback, $count, $column, $alias)
     * @method static mixed lazy($chunkSize)
     * @method static mixed lazyById($chunkSize, $column, $alias)
     * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
     * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
     * @method static mixed first($columns)
     * @method static mixed firstOrFail($columns, $message)
     * @method static mixed sole($columns)
     * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
     * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
     * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
     * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
     * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
     * @method static mixed tap($callback)
     * @method static mixed pipe($callback)
     * @method static mixed when($value, callable $callback, callable $default)
     * @method static mixed unless($value, callable $callback, callable $default)
     * @method static mixed explain()
     * @method static mixed forwardCallTo($object, $method, $parameters)
     * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
     * @method static mixed throwBadMethodCallException($method)
     * @method static mixed macro($name, $macro)
     * @method static mixed mixin($mixin, $replace)
     * @method static mixed hasMacro($name)
     * @method static mixed flushMacros()
     * @method static mixed macroCall($method, $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class User extends \Illuminate\Foundation\Auth\User
    {
        //
    }

}