<header class="bg-gradient-to-r from-blue-600 to-blue-800 shadow-lg sticky top-0 z-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            <!-- Logo -->
            <div class="flex items-center">
                <a href="<?php echo e(route('home')); ?>" class="flex items-center space-x-2">
                    <div class="bg-white text-blue-600 px-3 py-2 rounded-lg font-bold shadow-md">
                        MEDEX
                    </div>
                </a>
            </div>

            <!-- Navigation Links -->
            <nav class="hidden md:flex space-x-8">
                <a href="#section1" class="text-blue-100 hover:text-white transition-colors font-medium">Services</a>
                <a href="#section2" class="text-blue-100 hover:text-white transition-colors font-medium">How it Works</a>
                <a href="#section3" class="text-blue-100 hover:text-white transition-colors font-medium">Consultations</a>
                <a href="#section4" class="text-blue-100 hover:text-white transition-colors font-medium">Benefits</a>
                <a href="#section5" class="text-blue-100 hover:text-white transition-colors font-medium">Why Choose Us</a>
                <a href="#section6" class="text-blue-100 hover:text-white transition-colors font-medium">FAQ</a>
            </nav>

            <!-- Auth Buttons -->
            <div class="flex items-center space-x-4">
                <?php if(auth()->guard()->guest()): ?>
                    <a href="<?php echo e(route('login')); ?>" class="text-blue-100 hover:text-white transition-colors font-medium">Login</a>
                    <a href="<?php echo e(route('register')); ?>" class="bg-white text-blue-600 px-4 py-2 rounded-lg hover:bg-blue-50 transition-colors font-semibold shadow-md">Get Started</a>
                <?php else: ?>
                    <div class="relative">
                        <button type="button" class="flex items-center space-x-2 text-blue-100 hover:text-white" onclick="toggleDropdown()">
                            <span><?php echo e(Auth::user()->name); ?></span>
                            <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd"></path>
                            </svg>
                        </button>
                        
                        <div id="userDropdown" class="absolute right-0 mt-2 w-48 bg-white rounded-md shadow-lg py-1 hidden">
                            <?php if(Auth::user()->user_type === 'admin'): ?>
                                <a href="<?php echo e(route('admin.dashboard')); ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Admin Dashboard</a>
                            <?php elseif(Auth::user()->user_type === 'professional'): ?>
                                <a href="<?php echo e(route('professional.dashboard')); ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Dashboard</a>
                            <?php else: ?>
                                <a href="<?php echo e(route('client.dashboard')); ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Dashboard</a>
                            <?php endif; ?>
                            <form method="POST" action="<?php echo e(route('logout')); ?>">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Logout</button>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Mobile menu button -->
                <button type="button" class="md:hidden text-gray-600 hover:text-blue-600" onclick="toggleMobileMenu()">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Mobile Navigation -->
        <div id="mobileMenu" class="md:hidden hidden pb-4">
            <div class="flex flex-col space-y-2">
                <a href="#section1" class="text-gray-600 hover:text-blue-600 py-2">Services</a>
                <a href="#section2" class="text-gray-600 hover:text-blue-600 py-2">How it Works</a>
                <a href="#section3" class="text-gray-600 hover:text-blue-600 py-2">Consultations</a>
                <a href="#section4" class="text-gray-600 hover:text-blue-600 py-2">Benefits</a>
                <a href="#section5" class="text-gray-600 hover:text-blue-600 py-2">Why Choose Us</a>
                <a href="#section6" class="text-gray-600 hover:text-blue-600 py-2">FAQ</a>
            </div>
        </div>
    </div>
</header>

<script>
function toggleDropdown() {
    const dropdown = document.getElementById('userDropdown');
    dropdown.classList.toggle('hidden');
}

function toggleMobileMenu() {
    const mobileMenu = document.getElementById('mobileMenu');
    mobileMenu.classList.toggle('hidden');
}

// Close dropdown when clicking outside
document.addEventListener('click', function(event) {
    const dropdown = document.getElementById('userDropdown');
    const button = event.target.closest('button');
    
    if (!button || !button.onclick || button.onclick.toString().indexOf('toggleDropdown') === -1) {
        if (dropdown && !dropdown.classList.contains('hidden')) {
            dropdown.classList.add('hidden');
        }
    }
});
</script><?php /**PATH C:\laragon\www\Medex\resources\views/components/header.blade.php ENDPATH**/ ?>