

<?php $__env->startSection('title', 'Manage Reviews'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Manage Reviews</h5>
                </div>
                <div class="card-body">
                    <!-- Search Form -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" name="search" class="form-control" placeholder="Search reviews..." value="<?php echo e(request('search')); ?>">
                            </div>
                            <div class="col-md-4">
                                <select name="status" class="form-control">
                                    <option value="">All Status</option>
                                    <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                    <option value="approved" <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>Approved</option>
                                    <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary">Filter</button>
                            </div>
                        </div>
                    </form>

                    <!-- Reviews Table -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Client</th>
                                    <th>Professional</th>
                                    <th>Rating</th>
                                    <th>Comment</th>
                                    <th>Status</th>
                                    <th>Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($review->id); ?></td>
                                    <td><?php echo e($review->user->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($review->professional->user->name ?? 'N/A'); ?></td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <span><?php echo e($review->rating); ?>/5</span>
                                            <div class="ms-2">
                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                    <span class="text-<?php echo e($i <= $review->rating ? 'warning' : 'muted'); ?>">★</span>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="text-truncate" style="max-width: 200px;" title="<?php echo e($review->comment); ?>">
                                            <?php echo e($review->comment); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($review->status == 'approved' ? 'success' : ($review->status == 'pending' ? 'warning' : 'danger')); ?>">
                                            <?php echo e(ucfirst($review->status)); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($review->created_at->format('M d, Y')); ?></td>
                                    <td>
                                        <?php if($review->status === 'pending'): ?>
                                            <form action="<?php echo e(route('admin.reviews.approve', $review)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit" class="btn btn-sm btn-success" 
                                                        onclick="return confirm('Are you sure you want to approve this review?')">
                                                    Approve
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('review.show', $review)); ?>" class="btn btn-sm btn-primary">
                                            View
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-star fa-3x mb-3"></i>
                                            <p>No reviews found.</p>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <?php if($reviews->hasPages()): ?>
                        <div class="d-flex justify-content-center mt-4">
                            <?php echo e($reviews->appends(request()->query())->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if(session('success')): ?>
<script>
    alert('<?php echo e(session('success')); ?>');
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Medex\resources\views/admin/reviews.blade.php ENDPATH**/ ?>