

<?php $__env->startSection('title', 'Manage Subscription Plans'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Manage Subscription Plans</h5>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPlanModal">
                        <i class="fas fa-plus"></i> Add New Plan
                    </button>
                </div>
                <div class="card-body">
                    <!-- Subscription Plans Table -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Plan Name</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>Commission</th>
                                    <th>Features</th>
                                    <th>Premium</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $subscriptionPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($plan->id); ?></td>
                                    <td><strong><?php echo e($plan->name); ?></strong></td>
                                    <td>
                                        <div class="text-truncate" style="max-width: 200px;" title="<?php echo e($plan->description); ?>">
                                            <?php echo e($plan->description); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <strong class="text-primary">$<?php echo e(number_format($plan->monthly_price ?? 0, 2)); ?></strong>
                                        <?php if($plan->yearly_price): ?>
                                            <br><small class="text-muted">$<?php echo e(number_format($plan->yearly_price, 2)); ?>/year</small>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($plan->commission_percentage ?? 10); ?>%</td>
                                    <td>
                                        <?php if($plan->features): ?>
                                            <ul class="list-unstyled mb-0">
                                                <?php $__currentLoopData = $plan->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li><small>• <?php echo e($feature); ?></small></li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php else: ?>
                                            <span class="text-muted">No features listed</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex flex-column gap-1">
                                            <?php if($plan->priority_listing): ?>
                                                <span class="badge bg-info">Priority</span>
                                            <?php endif; ?>
                                            <?php if($plan->featured_profile): ?>
                                                <span class="badge bg-warning">Featured</span>
                                            <?php endif; ?>
                                            <?php if($plan->dedicated_support): ?>
                                                <span class="badge bg-success">Support</span>
                                            <?php endif; ?>
                                            <?php if($plan->max_consultations_per_month): ?>
                                                <small class="text-muted"><?php echo e($plan->max_consultations_per_month); ?> consults/month</small>
                                            <?php endif; ?>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($plan->is_active ? 'success' : 'secondary'); ?>">
                                            <?php echo e($plan->is_active ? 'Active' : 'Inactive'); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#editPlanModal<?php echo e($plan->id); ?>">
                                                Edit
                                            </button>
                                            <form action="<?php echo e(route('admin.subscription-plans.destroy', $plan)); ?>" method="POST" class="d-inline">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" class="btn btn-sm btn-outline-danger" 
                                                        onclick="return confirm('Are you sure you want to delete this plan?')">
                                                    Delete
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <div class="text-muted">
                                            <i class="fas fa-credit-card fa-3x mb-3"></i>
                                            <p>No subscription plans found.</p>
                                            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPlanModal">
                                                Create First Plan
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Plan Modal -->
<div class="modal fade" id="addPlanModal" tabindex="-1" aria-labelledby="addPlanModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addPlanModalLabel">Add New Subscription Plan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('admin.subscription-plans.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Plan Name</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="monthly_price" class="form-label">Monthly Price ($)</label>
                                <input type="number" step="0.01" class="form-control" id="monthly_price" name="monthly_price" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="yearly_price" class="form-label">Yearly Price ($) - Optional</label>
                                <input type="number" step="0.01" class="form-control" id="yearly_price" name="yearly_price">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="commission_percentage" class="form-label">Commission %</label>
                                <input type="number" step="0.01" max="100" class="form-control" id="commission_percentage" name="commission_percentage" value="10">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="max_consultations_per_month" class="form-label">Max Consultations/Month</label>
                                <input type="number" class="form-control" id="max_consultations_per_month" name="max_consultations_per_month">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="is_active" class="form-label">Status</label>
                                <select class="form-control" id="is_active" name="is_active">
                                    <option value="1">Active</option>
                                    <option value="0">Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Premium Features -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="priority_listing" name="priority_listing">
                                <label class="form-check-label" for="priority_listing">
                                    Priority Listing
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="featured_profile" name="featured_profile">
                                <label class="form-check-label" for="featured_profile">
                                    Featured Profile
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="dedicated_support" name="dedicated_support">
                                <label class="form-check-label" for="dedicated_support">
                                    Dedicated Support
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="features" class="form-label">Features (one per line)</label>
                        <textarea class="form-control" id="features" name="features" rows="4" placeholder="Enter features, one per line"></textarea>
                        <small class="text-muted">Each line will be treated as a separate feature</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Create Plan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Plan Modals -->
<?php $__currentLoopData = $subscriptionPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editPlanModal<?php echo e($plan->id); ?>" tabindex="-1" aria-labelledby="editPlanModalLabel<?php echo e($plan->id); ?>" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editPlanModalLabel<?php echo e($plan->id); ?>">Edit Subscription Plan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('admin.subscription-plans.update', $plan)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_name<?php echo e($plan->id); ?>" class="form-label">Plan Name</label>
                                <input type="text" class="form-control" id="edit_name<?php echo e($plan->id); ?>" name="name" value="<?php echo e($plan->name); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_monthly_price<?php echo e($plan->id); ?>" class="form-label">Monthly Price ($)</label>
                                <input type="number" step="0.01" class="form-control" id="edit_monthly_price<?php echo e($plan->id); ?>" name="monthly_price" value="<?php echo e($plan->monthly_price); ?>" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="edit_description<?php echo e($plan->id); ?>" class="form-label">Description</label>
                        <textarea class="form-control" id="edit_description<?php echo e($plan->id); ?>" name="description" rows="3"><?php echo e($plan->description); ?></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_yearly_price<?php echo e($plan->id); ?>" class="form-label">Yearly Price ($) - Optional</label>
                                <input type="number" step="0.01" class="form-control" id="edit_yearly_price<?php echo e($plan->id); ?>" name="yearly_price" value="<?php echo e($plan->yearly_price); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_commission_percentage<?php echo e($plan->id); ?>" class="form-label">Commission %</label>
                                <input type="number" step="0.01" max="100" class="form-control" id="edit_commission_percentage<?php echo e($plan->id); ?>" name="commission_percentage" value="<?php echo e($plan->commission_percentage ?? 10); ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_max_consultations<?php echo e($plan->id); ?>" class="form-label">Max Consultations/Month</label>
                                <input type="number" class="form-control" id="edit_max_consultations<?php echo e($plan->id); ?>" name="max_consultations_per_month" value="<?php echo e($plan->max_consultations_per_month); ?>">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="edit_is_active<?php echo e($plan->id); ?>" class="form-label">Status</label>
                                <select class="form-control" id="edit_is_active<?php echo e($plan->id); ?>" name="is_active">
                                    <option value="1" <?php echo e($plan->is_active ? 'selected' : ''); ?>>Active</option>
                                    <option value="0" <?php echo e(!$plan->is_active ? 'selected' : ''); ?>>Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Premium Features -->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="edit_priority_listing<?php echo e($plan->id); ?>" name="priority_listing" <?php echo e($plan->priority_listing ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="edit_priority_listing<?php echo e($plan->id); ?>">
                                    Priority Listing
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="edit_featured_profile<?php echo e($plan->id); ?>" name="featured_profile" <?php echo e($plan->featured_profile ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="edit_featured_profile<?php echo e($plan->id); ?>">
                                    Featured Profile
                                </label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-check mb-3">
                                <input class="form-check-input" type="checkbox" id="edit_dedicated_support<?php echo e($plan->id); ?>" name="dedicated_support" <?php echo e($plan->dedicated_support ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="edit_dedicated_support<?php echo e($plan->id); ?>">
                                    Dedicated Support
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="edit_features<?php echo e($plan->id); ?>" class="form-label">Features (one per line)</label>
                        <textarea class="form-control" id="edit_features<?php echo e($plan->id); ?>" name="features" rows="4" placeholder="Enter features, one per line"><?php echo e($plan->features ? implode("\n", $plan->features) : ''); ?></textarea>
                        <small class="text-muted">Each line will be treated as a separate feature</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Update Plan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php if(session('success')): ?>
<div class="alert alert-success alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 1050;" role="alert">
    <?php echo e(session('success')); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>

<?php if(session('error')): ?>
<div class="alert alert-danger alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 1050;" role="alert">
    <?php echo e(session('error')); ?>

    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php endif; ?>

<script>
// Auto dismiss alerts after 5 seconds
setTimeout(function() {
    $('.alert').fadeOut();
}, 5000);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Medex\resources\views/admin/subscription-plans.blade.php ENDPATH**/ ?>