

<?php $__env->startSection('content'); ?>
<div class="auth-header">
    <h1>Register for Medex</h1>
    <p>Join our platform to connect medical and legal professionals</p>
</div>

<?php if($errors->any()): ?>
    <div class="error-messages">
        <ul>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<form method="POST" action="<?php echo e(route('register')); ?>" id="registrationForm">
    <?php echo csrf_field(); ?>
    
    <!-- Personal Information -->
    <div class="form-group">
        <label class="form-label" for="name">Full Name *</label>
        <input id="name" class="form-input" type="text" name="name" value="<?php echo e(old('name')); ?>" required autofocus>
    </div>
    
    <div class="form-grid">
        <div class="form-group">
            <label class="form-label" for="email">Email Address *</label>
            <input id="email" class="form-input" type="email" name="email" value="<?php echo e(old('email')); ?>" required>
        </div>
        
        <div class="form-group">
            <label class="form-label" for="phone">Phone Number *</label>
            <input id="phone" class="form-input" type="tel" name="phone" value="<?php echo e(old('phone')); ?>" required>
        </div>
    </div>
    
    <div class="form-grid">
        <div class="form-group">
            <label class="form-label" for="password">Password *</label>
            <input id="password" class="form-input" type="password" name="password" required>
        </div>
        
        <div class="form-group">
            <label class="form-label" for="password_confirmation">Confirm Password *</label>
            <input id="password_confirmation" class="form-input" type="password" name="password_confirmation" required>
        </div>
    </div>
    
    <!-- User Type Selection -->
    <div class="form-group">
        <label class="form-label">I am a: *</label>
        <div class="role-cards">
            <div class="role-card" data-role="professional">
                <h3>🏛️ Legal/Financial Professional</h3>
                <p>Advocate, CA, CS, CMA offering consultation services</p>
            </div>
            <div class="role-card" data-role="client">
                <h3>🏥 Medical Professional</h3>
                <p>Doctor, Nurse, Pharmacist seeking legal/financial advice</p>
            </div>
        </div>
        <input type="hidden" name="user_type" id="user_type" value="<?php echo e(old('user_type')); ?>">
    </div>
    
    <!-- Professional Type (Hidden initially) -->
    <div class="form-group" id="professional_type_group" style="display: none;">
        <label class="form-label" for="profession_type">Professional Type *</label>
        <select id="profession_type" class="form-select" name="profession_type">
            <option value="">Select your profession</option>
            <option value="advocate" <?php echo e(old('profession_type') == 'advocate' ? 'selected' : ''); ?>>Advocate (Lawyer)</option>
            <option value="chartered_accountant" <?php echo e(old('profession_type') == 'chartered_accountant' ? 'selected' : ''); ?>>Chartered Accountant (CA)</option>
            <option value="company_secretary" <?php echo e(old('profession_type') == 'company_secretary' ? 'selected' : ''); ?>>Company Secretary (CS)</option>
            <option value="cost_management_accountant" <?php echo e(old('profession_type') == 'cost_management_accountant' ? 'selected' : ''); ?>>Cost & Management Accountant (CMA)</option>
        </select>
    </div>
    
    <!-- Client Type (Hidden initially) -->
    <div class="form-group" id="client_type_group" style="display: none;">
        <label class="form-label" for="client_profession">Medical Profession *</label>
        <select id="client_profession" class="form-select" name="client_profession">
            <option value="">Select your profession</option>
            <option value="doctor" <?php echo e(old('client_profession') == 'doctor' ? 'selected' : ''); ?>>Doctor</option>
            <option value="nurse" <?php echo e(old('client_profession') == 'nurse' ? 'selected' : ''); ?>>Nurse</option>
            <option value="pharmacist" <?php echo e(old('client_profession') == 'pharmacist' ? 'selected' : ''); ?>>Pharmacist</option>
            <option value="clinic_owner" <?php echo e(old('client_profession') == 'clinic_owner' ? 'selected' : ''); ?>>Clinic Owner</option>
            <option value="hospital_admin" <?php echo e(old('client_profession') == 'hospital_admin' ? 'selected' : ''); ?>>Hospital Administrator</option>
            <option value="medical_store_owner" <?php echo e(old('client_profession') == 'medical_store_owner' ? 'selected' : ''); ?>>Medical Store Owner</option>
        </select>
    </div>
    
    <!-- Location Information -->
    <div class="form-grid-3">
        <div class="form-group">
            <label class="form-label" for="city">City *</label>
            <input id="city" class="form-input" type="text" name="city" value="<?php echo e(old('city')); ?>" required>
        </div>
        
        <div class="form-group">
            <label class="form-label" for="pincode">PIN Code *</label>
            <input id="pincode" class="form-input" type="text" name="pincode" value="<?php echo e(old('pincode')); ?>" maxlength="6" required>
        </div>
    </div>
    
    <div class="form-group">
        <label class="form-label" for="state">State *</label>
        <select id="state" class="form-select" name="state" required>
            <option value="">Select State</option>
            <option value="Andhra Pradesh" <?php echo e(old('state') == 'Andhra Pradesh' ? 'selected' : ''); ?>>Andhra Pradesh</option>
            <option value="Arunachal Pradesh" <?php echo e(old('state') == 'Arunachal Pradesh' ? 'selected' : ''); ?>>Arunachal Pradesh</option>
            <option value="Assam" <?php echo e(old('state') == 'Assam' ? 'selected' : ''); ?>>Assam</option>
            <option value="Bihar" <?php echo e(old('state') == 'Bihar' ? 'selected' : ''); ?>>Bihar</option>
            <option value="Chhattisgarh" <?php echo e(old('state') == 'Chhattisgarh' ? 'selected' : ''); ?>>Chhattisgarh</option>
            <option value="Goa" <?php echo e(old('state') == 'Goa' ? 'selected' : ''); ?>>Goa</option>
            <option value="Gujarat" <?php echo e(old('state') == 'Gujarat' ? 'selected' : ''); ?>>Gujarat</option>
            <option value="Haryana" <?php echo e(old('state') == 'Haryana' ? 'selected' : ''); ?>>Haryana</option>
            <option value="Himachal Pradesh" <?php echo e(old('state') == 'Himachal Pradesh' ? 'selected' : ''); ?>>Himachal Pradesh</option>
            <option value="Jharkhand" <?php echo e(old('state') == 'Jharkhand' ? 'selected' : ''); ?>>Jharkhand</option>
            <option value="Karnataka" <?php echo e(old('state') == 'Karnataka' ? 'selected' : ''); ?>>Karnataka</option>
            <option value="Kerala" <?php echo e(old('state') == 'Kerala' ? 'selected' : ''); ?>>Kerala</option>
            <option value="Madhya Pradesh" <?php echo e(old('state') == 'Madhya Pradesh' ? 'selected' : ''); ?>>Madhya Pradesh</option>
            <option value="Maharashtra" <?php echo e(old('state') == 'Maharashtra' ? 'selected' : ''); ?>>Maharashtra</option>
            <option value="Manipur" <?php echo e(old('state') == 'Manipur' ? 'selected' : ''); ?>>Manipur</option>
            <option value="Meghalaya" <?php echo e(old('state') == 'Meghalaya' ? 'selected' : ''); ?>>Meghalaya</option>
            <option value="Mizoram" <?php echo e(old('state') == 'Mizoram' ? 'selected' : ''); ?>>Mizoram</option>
            <option value="Nagaland" <?php echo e(old('state') == 'Nagaland' ? 'selected' : ''); ?>>Nagaland</option>
            <option value="Odisha" <?php echo e(old('state') == 'Odisha' ? 'selected' : ''); ?>>Odisha</option>
            <option value="Punjab" <?php echo e(old('state') == 'Punjab' ? 'selected' : ''); ?>>Punjab</option>
            <option value="Rajasthan" <?php echo e(old('state') == 'Rajasthan' ? 'selected' : ''); ?>>Rajasthan</option>
            <option value="Sikkim" <?php echo e(old('state') == 'Sikkim' ? 'selected' : ''); ?>>Sikkim</option>
            <option value="Tamil Nadu" <?php echo e(old('state') == 'Tamil Nadu' ? 'selected' : ''); ?>>Tamil Nadu</option>
            <option value="Telangana" <?php echo e(old('state') == 'Telangana' ? 'selected' : ''); ?>>Telangana</option>
            <option value="Tripura" <?php echo e(old('state') == 'Tripura' ? 'selected' : ''); ?>>Tripura</option>
            <option value="Uttar Pradesh" <?php echo e(old('state') == 'Uttar Pradesh' ? 'selected' : ''); ?>>Uttar Pradesh</option>
            <option value="Uttarakhand" <?php echo e(old('state') == 'Uttarakhand' ? 'selected' : ''); ?>>Uttarakhand</option>
            <option value="West Bengal" <?php echo e(old('state') == 'West Bengal' ? 'selected' : ''); ?>>West Bengal</option>
            <option value="Delhi" <?php echo e(old('state') == 'Delhi' ? 'selected' : ''); ?>>Delhi</option>
        </select>
    </div>
    
    <div class="form-group">
        <button class="btn btn-primary" type="submit">Create Account</button>
    </div>
</form>

<div class="auth-links">
    <p>Already have an account? <a href="<?php echo e(route('login')); ?>">Sign in</a></p>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const roleCards = document.querySelectorAll('.role-card');
    const userTypeInput = document.getElementById('user_type');
    const professionalTypeGroup = document.getElementById('professional_type_group');
    const clientTypeGroup = document.getElementById('client_type_group');
    
    // Set initial state based on old input
    const oldUserType = "<?php echo e(old('user_type')); ?>";
    if (oldUserType) {
        const selectedCard = document.querySelector(`[data-role="${oldUserType}"]`);
        if (selectedCard) {
            selectedCard.classList.add('selected');
            userTypeInput.value = oldUserType;
            toggleProfessionFields(oldUserType);
        }
    }
    
    roleCards.forEach(card => {
        card.addEventListener('click', function() {
            // Remove selected class from all cards
            roleCards.forEach(c => c.classList.remove('selected'));
            
            // Add selected class to clicked card
            this.classList.add('selected');
            
            // Update hidden input
            const role = this.getAttribute('data-role');
            userTypeInput.value = role;
            
            // Show/hide profession fields
            toggleProfessionFields(role);
        });
    });
    
    function toggleProfessionFields(role) {
        if (role === 'professional') {
            professionalTypeGroup.style.display = 'block';
            clientTypeGroup.style.display = 'none';
            document.getElementById('profession_type').required = true;
            document.getElementById('client_profession').required = false;
        } else if (role === 'client') {
            professionalTypeGroup.style.display = 'none';
            clientTypeGroup.style.display = 'block';
            document.getElementById('profession_type').required = false;
            document.getElementById('client_profession').required = true;
        } else {
            professionalTypeGroup.style.display = 'none';
            clientTypeGroup.style.display = 'none';
            document.getElementById('profession_type').required = false;
            document.getElementById('client_profession').required = false;
        }
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.auth', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\Medex\resources\views/auth/register.blade.php ENDPATH**/ ?>