<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ProfessionalController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\ConsultationController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\ReviewController;

// Public routes
Route::get('/', function () {
    return view('welcome');
})->name('home');

// Authentication routes
Route::middleware('guest')->group(function () {
    Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
    Route::post('/register', [AuthController::class, 'register']);
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('/login', [AuthController::class, 'login']);
});

Route::post('/logout', [AuthController::class, 'logout'])->middleware('auth')->name('logout');

// Review routes
Route::middleware(['auth'])->group(function () {
    Route::get('/consultation/{consultation}/review', [ReviewController::class, 'create'])->name('review.create');
    Route::post('/consultation/{consultation}/review', [ReviewController::class, 'store'])->name('review.store');
    Route::get('/review/{review}', [ReviewController::class, 'show'])->name('review.show');
    Route::put('/review/{review}', [ReviewController::class, 'update'])->name('review.update');
    Route::get('/professional/{professional}/reviews', [ReviewController::class, 'professionalReviews'])->name('review.professional');
    Route::get('/my-reviews', [ReviewController::class, 'myReviews'])->name('review.my-reviews');
    Route::get('/reviews/received', [ReviewController::class, 'receivedReviews'])->name('review.received');
    Route::post('/review/{review}/report', [ReviewController::class, 'report'])->name('review.report');
});

// Payment routes
Route::middleware(['auth'])->group(function () {
    Route::get('/payment/consultation/{consultation}', [PaymentController::class, 'showConsultationPayment'])->name('payment.consultation');
    Route::get('/payment/subscription/{subscription}', [PaymentController::class, 'showSubscriptionPayment'])->name('payment.subscription');
    Route::post('/payment/success', [PaymentController::class, 'paymentSuccess'])->name('payment.success');
    Route::post('/payment/failure', [PaymentController::class, 'paymentFailure'])->name('payment.failure');
    Route::get('/payment/history', [PaymentController::class, 'paymentHistory'])->name('payment.history');
    Route::get('/payment/invoice/{payment}', [PaymentController::class, 'downloadInvoice'])->name('payment.invoice');
    Route::post('/payment/{payment}/refund', [PaymentController::class, 'requestRefund'])->name('payment.refund');
});

// Professional routes
Route::middleware(['auth'])->prefix('professional')->name('professional.')->group(function () {
    Route::get('/dashboard', [ProfessionalController::class, 'dashboard'])->name('dashboard');
    Route::get('/profile', [ProfessionalController::class, 'profile'])->name('profile');
    Route::put('/profile', [ProfessionalController::class, 'updateProfile'])->name('profile.update');
    Route::get('/consultations', [ProfessionalController::class, 'consultations'])->name('consultations');
    Route::get('/earnings', [ProfessionalController::class, 'earnings'])->name('earnings');
    Route::get('/subscription', [ProfessionalController::class, 'subscription'])->name('subscription');
    Route::post('/subscription/upgrade', [ProfessionalController::class, 'upgradeSubscription'])->name('subscription.upgrade');
});

// Client routes
Route::middleware(['auth'])->prefix('client')->name('client.')->group(function () {
    Route::get('/dashboard', [ClientController::class, 'dashboard'])->name('dashboard');
    Route::get('/profile', [ClientController::class, 'profile'])->name('profile');
    Route::put('/profile', [ClientController::class, 'updateProfile'])->name('profile.update');
    Route::get('/professionals', [ClientController::class, 'searchProfessionals'])->name('professionals');
    Route::get('/consultations', [ClientController::class, 'consultations'])->name('consultations');
    Route::get('/book/{professional}', [ClientController::class, 'bookConsultation'])->name('book');
    Route::post('/book/{professional}', [ClientController::class, 'storeBooking'])->name('book.store');
});

// Admin routes
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [AdminController::class, 'dashboard'])->name('dashboard');
    Route::get('/professionals', [AdminController::class, 'professionals'])->name('professionals');
    Route::post('/professionals/{professional}/verify', [AdminController::class, 'verifyProfessional'])->name('professionals.verify');
    Route::get('/clients', [AdminController::class, 'clients'])->name('clients');
    Route::get('/consultations', [AdminController::class, 'consultations'])->name('consultations');
    Route::get('/reviews', [AdminController::class, 'reviews'])->name('reviews.index');
    Route::post('/reviews/{review}/approve', [AdminController::class, 'approveReview'])->name('reviews.approve');
    Route::get('/subscription-plans', [AdminController::class, 'subscriptionPlans'])->name('subscription-plans');
    Route::post('/subscription-plans', [AdminController::class, 'storeSubscriptionPlan'])->name('subscription-plans.store');
    Route::put('/subscription-plans/{subscriptionPlan}', [AdminController::class, 'updateSubscriptionPlan'])->name('subscription-plans.update');
    Route::delete('/subscription-plans/{subscriptionPlan}', [AdminController::class, 'destroySubscriptionPlan'])->name('subscription-plans.destroy');
    Route::get('/payments', [AdminController::class, 'payments'])->name('payments');
});

// Consultation routes (shared)
Route::middleware(['auth'])->prefix('consultation')->name('consultation.')->group(function () {
    Route::get('/{consultation}', [ConsultationController::class, 'show'])->name('show');
    Route::post('/{consultation}/start', [ConsultationController::class, 'start'])->name('start');
    Route::post('/{consultation}/end', [ConsultationController::class, 'end'])->name('end');
    Route::post('/{consultation}/review', [ConsultationController::class, 'review'])->name('review');
    Route::get('/{consultation}/meeting', [ConsultationController::class, 'joinMeeting'])->name('meeting');
});

// API routes (for future mobile app)
Route::prefix('api')->group(function () {
    // API routes will be added here when api.php is created
});
