@extends('layouts.app')

@section('title', 'Subscription Payment')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h4 class="mb-0">Subscription Payment</h4>
                </div>
                <div class="card-body">
                    <!-- Subscription Details -->
                    <div class="mb-4">
                        <h5>Subscription Details</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <h6 class="card-title text-{{ $subscription->subscriptionPlan->name == 'Silver' ? 'secondary' : ($subscription->subscriptionPlan->name == 'Gold' ? 'warning' : 'dark') }}">
                                            {{ $subscription->subscriptionPlan->name }} Plan
                                        </h6>
                                        <p class="card-text">
                                            <strong>Monthly Fee:</strong> ₹{{ number_format($subscription->subscriptionPlan->monthly_fee, 2) }}<br>
                                            <strong>Commission Rate:</strong> {{ $subscription->subscriptionPlan->commission_rate }}%<br>
                                            <strong>Features:</strong> {{ $subscription->subscriptionPlan->features }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <p><strong>Start Date:</strong> {{ $subscription->start_date->format('d M Y') }}</p>
                                <p><strong>Next Billing:</strong> {{ $subscription->next_billing_date->format('d M Y') }}</p>
                                <p><strong>Status:</strong> 
                                    <span class="badge bg-{{ $subscription->status == 'active' ? 'success' : 'warning' }}">
                                        {{ ucfirst($subscription->status) }}
                                    </span>
                                </p>
                                <p><strong>Auto Renewal:</strong> 
                                    <span class="badge bg-{{ $subscription->auto_renewal ? 'info' : 'secondary' }}">
                                        {{ $subscription->auto_renewal ? 'Enabled' : 'Disabled' }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Details -->
                    <div class="mb-4">
                        <h5>Payment Breakdown</h5>
                        <div class="table-responsive">
                            <table class="table">
                                <tr>
                                    <td>Subscription Fee</td>
                                    <td>₹{{ number_format($payment->base_amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td>GST (18%)</td>
                                    <td>₹{{ number_format($payment->gst_amount, 2) }}</td>
                                </tr>
                                @if($payment->platform_fee)
                                <tr>
                                    <td>Setup Fee</td>
                                    <td>₹{{ number_format($payment->platform_fee, 2) }}</td>
                                </tr>
                                @endif
                                <tr class="table-success">
                                    <td><strong>Total Amount</strong></td>
                                    <td><strong>₹{{ number_format($payment->total_amount, 2) }}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Benefits Section -->
                    <div class="mb-4">
                        <h5>What You Get</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <ul class="list-unstyled">
                                    <li><i class="fas fa-check text-success me-2"></i>Higher commission rate</li>
                                    <li><i class="fas fa-check text-success me-2"></i>Priority booking slots</li>
                                    <li><i class="fas fa-check text-success me-2"></i>Enhanced profile visibility</li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <ul class="list-unstyled">
                                    <li><i class="fas fa-check text-success me-2"></i>Advanced analytics dashboard</li>
                                    <li><i class="fas fa-check text-success me-2"></i>Marketing tools</li>
                                    <li><i class="fas fa-check text-success me-2"></i>24/7 priority support</li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Form -->
                    <div class="payment-section">
                        <h5>Complete Your Payment</h5>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="card">
                                    <div class="card-body text-center">
                                        <i class="fas fa-credit-card fa-2x text-primary mb-2"></i>
                                        <h6>Credit/Debit Card</h6>
                                        <small class="text-muted">Instant activation</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="netbanking">
                                    <div class="card-body text-center">
                                        <i class="fas fa-university fa-2x text-success mb-2"></i>
                                        <h6>Net Banking</h6>
                                        <small class="text-muted">All major banks</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="upi">
                                    <div class="card-body text-center">
                                        <i class="fas fa-mobile-alt fa-2x text-info mb-2"></i>
                                        <h6>UPI Payment</h6>
                                        <small class="text-muted">Quick & secure</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="wallet">
                                    <div class="card-body text-center">
                                        <i class="fas fa-wallet fa-2x text-warning mb-2"></i>
                                        <h6>Digital Wallets</h6>
                                        <small class="text-muted">Paytm, Mobikwik</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Auto Renewal Option -->
                        <div class="card mb-3">
                            <div class="card-body">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="autoRenewal" 
                                           {{ $subscription->auto_renewal ? 'checked' : '' }}>
                                    <label class="form-check-label" for="autoRenewal">
                                        <strong>Enable Auto-Renewal</strong>
                                        <small class="d-block text-muted">
                                            Automatically renew your subscription to avoid service interruption. 
                                            You can cancel anytime.
                                        </small>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2">
                            <button id="payBtn" class="btn btn-success btn-lg" disabled>
                                <i class="fas fa-shield-alt me-2"></i>
                                Pay & Activate ₹{{ number_format($payment->total_amount, 2) }}
                            </button>
                        </div>

                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="fas fa-lock me-1"></i>
                                Secured by 256-bit SSL encryption
                            </small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Policy Information -->
            <div class="card mt-3">
                <div class="card-body">
                    <h6>Subscription Policy</h6>
                    <ul class="small text-muted">
                        <li>Subscription will be activated immediately after successful payment</li>
                        <li>Monthly billing cycle starts from the activation date</li>
                        <li>You can upgrade or downgrade your plan anytime</li>
                        <li>Cancellation takes effect at the end of the current billing cycle</li>
                        <li>Refunds are processed as per our refund policy</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const paymentMethods = document.querySelectorAll('.payment-method');
    const payBtn = document.getElementById('payBtn');
    const autoRenewalCheck = document.getElementById('autoRenewal');
    let selectedMethod = null;

    // Payment method selection
    paymentMethods.forEach(method => {
        method.addEventListener('click', function() {
            paymentMethods.forEach(pm => pm.classList.remove('border-success'));
            this.classList.add('border-success');
            selectedMethod = this.dataset.method;
            payBtn.disabled = false;
        });
    });

    // Payment processing
    payBtn.addEventListener('click', function() {
        if (!selectedMethod) {
            alert('Please select a payment method');
            return;
        }

        // Show loading state
        this.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
        this.disabled = true;

        // Mock payment processing
        setTimeout(() => {
            const paymentData = {
                payment_id: '{{ $payment->payment_id }}',
                gateway_payment_id: 'sub_' + Math.random().toString(36).substr(2, 9),
                gateway_signature: 'sig_' + Math.random().toString(36).substr(2, 16),
                method: selectedMethod,
                auto_renewal: autoRenewalCheck.checked ? 1 : 0
            };

            // Create and submit form
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '{{ route("payment.success") }}';
            
            const csrfInput = document.createElement('input');
            csrfInput.type = 'hidden';
            csrfInput.name = '_token';
            csrfInput.value = '{{ csrf_token() }}';
            form.appendChild(csrfInput);

            Object.keys(paymentData).forEach(key => {
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = key;
                input.value = paymentData[key];
                form.appendChild(input);
            });

            document.body.appendChild(form);
            form.submit();
        }, 2000);
    });
});
</script>
@endpush

@push('styles')
<style>
.payment-method {
    cursor: pointer;
    transition: all 0.3s;
    border: 2px solid transparent;
}

.payment-method:hover {
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.payment-method.border-success {
    border-color: var(--bs-success) !important;
}

.table td {
    border-top: none;
    padding: 0.5rem;
}
</style>
@endpush
@endsection