@extends('layouts.app')

@section('title', 'Invoice')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card" id="invoice">
                <div class="card-body p-5">
                    <!-- Invoice Header -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h2 class="text-primary">MEDEX</h2>
                            <p class="text-muted mb-0">Legal & Financial Consultation Platform</p>
                            <p class="text-muted mb-0">Delhi, India</p>
                            <p class="text-muted">GSTIN: 07ABCDE1234F1Z5</p>
                        </div>
                        <div class="col-md-6 text-md-end">
                            <h4>INVOICE</h4>
                            <p class="mb-1"><strong>Invoice #:</strong> INV-{{ $payment->payment_id }}</p>
                            <p class="mb-1"><strong>Date:</strong> {{ $payment->created_at->format('d M Y') }}</p>
                            <p class="mb-1"><strong>Due Date:</strong> {{ $payment->created_at->format('d M Y') }}</p>
                        </div>
                    </div>

                    <!-- Bill To Section -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <h5>Bill To:</h5>
                            <p class="mb-1"><strong>{{ $payment->user->name }}</strong></p>
                            <p class="mb-1">{{ $payment->user->email }}</p>
                            @if($payment->user->phone)
                                <p class="mb-1">{{ $payment->user->phone }}</p>
                            @endif
                            @if(isset($invoiceData['billing_address']))
                                <p class="mb-0">{{ $invoiceData['billing_address'] }}</p>
                            @endif
                        </div>
                        <div class="col-md-6">
                            <h5>Payment Details:</h5>
                            <p class="mb-1"><strong>Payment ID:</strong> {{ $payment->payment_id }}</p>
                            <p class="mb-1"><strong>Gateway ID:</strong> {{ $payment->gateway_payment_id ?? 'N/A' }}</p>
                            <p class="mb-1"><strong>Method:</strong> {{ ucfirst($payment->payment_method ?? 'Card') }}</p>
                            <p class="mb-1"><strong>Status:</strong> 
                                <span class="badge bg-success">{{ ucfirst($payment->status) }}</span>
                            </p>
                        </div>
                    </div>

                    <!-- Service Details -->
                    <div class="mb-4">
                        <h5>Service Details:</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="table-light">
                                    <tr>
                                        <th>Description</th>
                                        <th width="120">Quantity</th>
                                        <th width="120">Rate</th>
                                        <th width="120">Amount</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if($payment->payable_type == 'App\\Models\\Consultation')
                                        <tr>
                                            <td>
                                                <strong>Medical Consultation</strong><br>
                                                <small class="text-muted">
                                                    Professional: {{ $payment->payable->professional->user->name }}<br>
                                                    Date: {{ $payment->payable->scheduled_at->format('d M Y, h:i A') }}<br>
                                                    Duration: {{ $payment->payable->duration }} minutes
                                                </small>
                                            </td>
                                            <td class="text-center">1</td>
                                            <td class="text-end">₹{{ number_format($payment->base_amount, 2) }}</td>
                                            <td class="text-end">₹{{ number_format($payment->base_amount, 2) }}</td>
                                        </tr>
                                    @elseif($payment->payable_type == 'App\\Models\\Subscription')
                                        <tr>
                                            <td>
                                                <strong>{{ $payment->payable->subscriptionPlan->name }} Plan Subscription</strong><br>
                                                <small class="text-muted">
                                                    Monthly subscription for professional services<br>
                                                    Period: {{ $payment->payable->start_date->format('M Y') }}<br>
                                                    Commission Rate: {{ $payment->payable->subscriptionPlan->commission_rate }}%
                                                </small>
                                            </td>
                                            <td class="text-center">1</td>
                                            <td class="text-end">₹{{ number_format($payment->base_amount, 2) }}</td>
                                            <td class="text-end">₹{{ number_format($payment->base_amount, 2) }}</td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <!-- Tax Calculation -->
                    <div class="row justify-content-end">
                        <div class="col-md-6">
                            <table class="table">
                                <tr>
                                    <td><strong>Subtotal:</strong></td>
                                    <td class="text-end">₹{{ number_format($payment->base_amount, 2) }}</td>
                                </tr>
                                @if($payment->platform_fee > 0)
                                <tr>
                                    <td><strong>Platform Fee:</strong></td>
                                    <td class="text-end">₹{{ number_format($payment->platform_fee, 2) }}</td>
                                </tr>
                                @endif
                                <tr>
                                    <td><strong>CGST (9%):</strong></td>
                                    <td class="text-end">₹{{ number_format($payment->gst_amount / 2, 2) }}</td>
                                </tr>
                                <tr>
                                    <td><strong>SGST (9%):</strong></td>
                                    <td class="text-end">₹{{ number_format($payment->gst_amount / 2, 2) }}</td>
                                </tr>
                                <tr class="table-dark">
                                    <td><strong>Total Amount:</strong></td>
                                    <td class="text-end"><strong>₹{{ number_format($payment->total_amount, 2) }}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Payment Status -->
                    <div class="alert alert-success mb-4">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-check-circle fa-2x me-3"></i>
                            <div>
                                <strong>Payment Successful</strong><br>
                                <small>This invoice has been paid in full on {{ $payment->created_at->format('d M Y') }}</small>
                            </div>
                        </div>
                    </div>

                    <!-- Terms and Conditions -->
                    <div class="border-top pt-4">
                        <h6>Terms & Conditions:</h6>
                        <ul class="small text-muted">
                            <li>Payment is non-refundable except as per our refund policy</li>
                            <li>GST is charged as per Indian tax regulations</li>
                            <li>For any queries, contact support@medex.com</li>
                            <li>This is a computer generated invoice and does not require signature</li>
                        </ul>
                    </div>

                    <!-- Footer -->
                    <div class="text-center mt-4">
                        <p class="text-muted mb-0">Thank you for using Medex!</p>
                        <small class="text-muted">Generated on {{ now()->format('d M Y H:i:s') }}</small>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="text-center mt-3 no-print">
                <button onclick="window.print()" class="btn btn-primary">
                    <i class="fas fa-print me-2"></i>Print Invoice
                </button>
                <button onclick="downloadPDF()" class="btn btn-success">
                    <i class="fas fa-download me-2"></i>Download PDF
                </button>
                <a href="{{ url()->previous() }}" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Back
                </a>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    body {
        font-size: 12px;
    }
    
    .card {
        border: none !important;
        box-shadow: none !important;
    }
    
    .container {
        max-width: none !important;
        padding: 0 !important;
        margin: 0 !important;
    }
}

.invoice-logo {
    max-height: 60px;
}

table {
    page-break-inside: avoid;
}

.table td, .table th {
    vertical-align: middle;
}
</style>
@endpush

@push('scripts')
<script>
function downloadPDF() {
    // In a real application, this would generate and download a PDF
    // For now, we'll use the print functionality
    alert('PDF download functionality would be implemented here. Using print dialog instead.');
    window.print();
}

// Auto-focus for better user experience
document.addEventListener('DOMContentLoaded', function() {
    // Add any additional invoice-specific JavaScript here
});
</script>
@endpush
@endsection