@extends('layouts.app')

@section('title', 'Payment for Consultation')

@section('content')
<div class="container mt-4">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0">Payment for Consultation</h4>
                </div>
                <div class="card-body">
                    <!-- Consultation Details -->
                    <div class="mb-4">
                        <h5>Consultation Details</h5>
                        <div class="row">
                            <div class="col-md-6">
                                <p><strong>Professional:</strong> {{ $consultation->professional->user->name }}</p>
                                <p><strong>Specialty:</strong> {{ $consultation->professional->specialty }}</p>
                                <p><strong>Date:</strong> {{ $consultation->scheduled_at->format('d M Y') }}</p>
                                <p><strong>Time:</strong> {{ $consultation->scheduled_at->format('h:i A') }}</p>
                            </div>
                            <div class="col-md-6">
                                <p><strong>Duration:</strong> {{ $consultation->duration }} minutes</p>
                                <p><strong>Type:</strong> {{ ucfirst($consultation->consultation_type) }}</p>
                                <p><strong>Status:</strong> 
                                    <span class="badge bg-warning">{{ ucfirst($consultation->status) }}</span>
                                </p>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Details -->
                    <div class="mb-4">
                        <h5>Payment Details</h5>
                        <div class="table-responsive">
                            <table class="table">
                                <tr>
                                    <td>Base Amount</td>
                                    <td>₹{{ number_format($payment->base_amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td>GST (18%)</td>
                                    <td>₹{{ number_format($payment->gst_amount, 2) }}</td>
                                </tr>
                                <tr>
                                    <td>Platform Fee</td>
                                    <td>₹{{ number_format($payment->platform_fee ?? 0, 2) }}</td>
                                </tr>
                                <tr class="table-primary">
                                    <td><strong>Total Amount</strong></td>
                                    <td><strong>₹{{ number_format($payment->total_amount, 2) }}</strong></td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    <!-- Payment Form -->
                    <div class="payment-section">
                        <h5>Select Payment Method</h5>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="razorpay">
                                    <div class="card-body text-center">
                                        <i class="fas fa-credit-card fa-2x text-primary mb-2"></i>
                                        <h6>Credit/Debit Card</h6>
                                        <small class="text-muted">Visa, Mastercard, RuPay</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="netbanking">
                                    <div class="card-body text-center">
                                        <i class="fas fa-university fa-2x text-success mb-2"></i>
                                        <h6>Net Banking</h6>
                                        <small class="text-muted">All major banks</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="upi">
                                    <div class="card-body text-center">
                                        <i class="fas fa-mobile-alt fa-2x text-info mb-2"></i>
                                        <h6>UPI</h6>
                                        <small class="text-muted">Google Pay, PhonePe, Paytm</small>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="card payment-method" data-method="wallet">
                                    <div class="card-body text-center">
                                        <i class="fas fa-wallet fa-2x text-warning mb-2"></i>
                                        <h6>Wallets</h6>
                                        <small class="text-muted">Paytm, Mobikwik, etc.</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2">
                            <button id="payBtn" class="btn btn-primary btn-lg" disabled>
                                <i class="fas fa-shield-alt me-2"></i>
                                Pay Securely ₹{{ number_format($payment->total_amount, 2) }}
                            </button>
                        </div>

                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="fas fa-lock me-1"></i>
                                Your payment is secured with 256-bit SSL encryption
                            </small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Terms and Conditions -->
            <div class="card mt-3">
                <div class="card-body">
                    <h6>Terms and Conditions</h6>
                    <ul class="small text-muted">
                        <li>Payment must be completed before the consultation starts</li>
                        <li>Refunds are available up to 2 hours before the scheduled consultation</li>
                        <li>Partial refunds may apply based on our refund policy</li>
                        <li>By proceeding with payment, you agree to our Terms of Service and Privacy Policy</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Payment method selection
    const paymentMethods = document.querySelectorAll('.payment-method');
    const payBtn = document.getElementById('payBtn');
    let selectedMethod = null;

    paymentMethods.forEach(method => {
        method.addEventListener('click', function() {
            // Remove previous selection
            paymentMethods.forEach(pm => pm.classList.remove('border-primary'));
            
            // Add selection to clicked method
            this.classList.add('border-primary');
            selectedMethod = this.dataset.method;
            
            // Enable pay button
            payBtn.disabled = false;
        });
    });

    // Payment processing (mock implementation)
    payBtn.addEventListener('click', function() {
        if (!selectedMethod) {
            alert('Please select a payment method');
            return;
        }

        // Show loading state
        this.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Processing...';
        this.disabled = true;

        // Mock payment processing
        setTimeout(() => {
            // Simulate successful payment
            const paymentData = {
                payment_id: '{{ $payment->payment_id }}',
                gateway_payment_id: 'pay_' + Math.random().toString(36).substr(2, 9),
                gateway_signature: 'sig_' + Math.random().toString(36).substr(2, 16),
                method: selectedMethod
            };

            // In production, this would be handled by payment gateway callback
            // For demo, we'll redirect to success page
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '{{ route("payment.success") }}';
            
            // Add CSRF token
            const csrfInput = document.createElement('input');
            csrfInput.type = 'hidden';
            csrfInput.name = '_token';
            csrfInput.value = '{{ csrf_token() }}';
            form.appendChild(csrfInput);

            // Add payment data
            Object.keys(paymentData).forEach(key => {
                const input = document.createElement('input');
                input.type = 'hidden';
                input.name = key;
                input.value = paymentData[key];
                form.appendChild(input);
            });

            document.body.appendChild(form);
            form.submit();
        }, 2000);
    });
});
</script>
@endpush

@push('styles')
<style>
.payment-method {
    cursor: pointer;
    transition: all 0.3s;
    border: 2px solid transparent;
}

.payment-method:hover {
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}

.payment-method.border-primary {
    border-color: var(--bs-primary) !important;
}

.table td {
    border-top: none;
    padding: 0.5rem;
}
</style>
@endpush
@endsection