<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>@yield('title', 'Medex - Legal & Financial Consultation Platform')</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Custom Styles -->
    @stack('styles')
    
    <style>
        :root {
            --primary-color: #0d6efd;
            --secondary-color: #6c757d;
            --success-color: #198754;
            --danger-color: #dc3545;
            --warning-color: #ffc107;
            --info-color: #0dcaf0;
        }
        
        body {
            background-color: #f8f9fa;
        }
        
        .navbar-brand {
            font-weight: bold;
            font-size: 1.5rem;
        }
        
        .sidebar {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.8);
            padding: 0.75rem 1rem;
            border-radius: 0.375rem;
            margin: 0.2rem 0;
        }
        
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            color: white;
            background-color: rgba(255, 255, 255, 0.1);
        }
        
        .main-content {
            margin-left: 0;
            transition: margin-left 0.3s;
        }
        
        @media (min-width: 768px) {
            .main-content {
                margin-left: 250px;
            }
        }
        
        .card {
            border: none;
            border-radius: 0.75rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        }
        
        .btn {
            border-radius: 0.375rem;
        }
        
        .alert {
            border-radius: 0.5rem;
        }
        
        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
        }
        
        .badge {
            font-size: 0.7rem;
        }
        
        .text-primary { color: var(--primary-color) !important; }
        .text-success { color: var(--success-color) !important; }
        .text-danger { color: var(--danger-color) !important; }
        .text-warning { color: var(--warning-color) !important; }
        .text-info { color: var(--info-color) !important; }
        
        .bg-primary { background-color: var(--primary-color) !important; }
        .bg-success { background-color: var(--success-color) !important; }
        .bg-danger { background-color: var(--danger-color) !important; }
        .bg-warning { background-color: var(--warning-color) !important; }
        .bg-info { background-color: var(--info-color) !important; }
    </style>
</head>
<body>
    <div class="d-flex">
        <!-- Sidebar -->
        @if(auth()->check())
        <div class="sidebar position-fixed d-none d-md-block" style="width: 250px; z-index: 1000;">
            <div class="p-3 text-white">
                <h4 class="mb-4">
                    <i class="fas fa-hospital-user me-2"></i>
                    MEDEX
                </h4>
                
                <nav class="nav flex-column">
                    @if(auth()->user()->user_type === 'admin')
                        <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" 
                           href="{{ route('admin.dashboard') }}">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link {{ request()->routeIs('admin.professionals*') ? 'active' : '' }}" 
                           href="{{ route('admin.professionals') }}">
                            <i class="fas fa-user-tie me-2"></i>Professionals
                        </a>
                        <a class="nav-link {{ request()->routeIs('admin.clients*') ? 'active' : '' }}" 
                           href="{{ route('admin.clients') }}">
                            <i class="fas fa-users me-2"></i>Clients
                        </a>
                        <a class="nav-link {{ request()->routeIs('admin.consultations*') ? 'active' : '' }}" 
                           href="{{ route('admin.consultations') }}">
                            <i class="fas fa-calendar-check me-2"></i>Consultations
                        </a>
                        <a class="nav-link {{ request()->routeIs('admin.payments*') ? 'active' : '' }}" 
                           href="{{ route('admin.payments') }}">
                            <i class="fas fa-credit-card me-2"></i>Payments
                        </a>
                        <a class="nav-link {{ request()->routeIs('admin.reviews*') ? 'active' : '' }}" 
                           href="{{ route('admin.reviews.index') }}">
                            <i class="fas fa-star me-2"></i>Reviews
                        </a>
                        <a class="nav-link {{ request()->routeIs('admin.subscription-plans*') ? 'active' : '' }}" 
                           href="{{ route('admin.subscription-plans') }}">
                            <i class="fas fa-crown me-2"></i>Plans
                        </a>
                    @elseif(auth()->user()->user_type === 'professional')
                        <a class="nav-link {{ request()->routeIs('professional.dashboard') ? 'active' : '' }}" 
                           href="{{ route('professional.dashboard') }}">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link {{ request()->routeIs('professional.profile*') ? 'active' : '' }}" 
                           href="{{ route('professional.profile') }}">
                            <i class="fas fa-user me-2"></i>Profile
                        </a>
                        <a class="nav-link {{ request()->routeIs('professional.consultations*') ? 'active' : '' }}" 
                           href="{{ route('professional.consultations') }}">
                            <i class="fas fa-calendar me-2"></i>Consultations
                        </a>
                        <a class="nav-link {{ request()->routeIs('professional.earnings*') ? 'active' : '' }}" 
                           href="{{ route('professional.earnings') }}">
                            <i class="fas fa-rupee-sign me-2"></i>Earnings
                        </a>
                        <a class="nav-link {{ request()->routeIs('professional.subscription*') ? 'active' : '' }}" 
                           href="{{ route('professional.subscription') }}">
                            <i class="fas fa-crown me-2"></i>Subscription
                        </a>
                        <a class="nav-link {{ request()->routeIs('review.received') ? 'active' : '' }}" 
                           href="{{ route('review.received') }}">
                            <i class="fas fa-star me-2"></i>Reviews
                        </a>
                    @elseif(auth()->user()->user_type === 'client')
                        <a class="nav-link {{ request()->routeIs('client.dashboard') ? 'active' : '' }}" 
                           href="{{ route('client.dashboard') }}">
                            <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                        </a>
                        <a class="nav-link {{ request()->routeIs('client.profile*') ? 'active' : '' }}" 
                           href="{{ route('client.profile') }}">
                            <i class="fas fa-user me-2"></i>Profile
                        </a>
                        <a class="nav-link {{ request()->routeIs('client.professionals*') ? 'active' : '' }}" 
                           href="{{ route('client.professionals') }}">
                            <i class="fas fa-search me-2"></i>Find Professionals
                        </a>
                        <a class="nav-link {{ request()->routeIs('client.consultations*') ? 'active' : '' }}" 
                           href="{{ route('client.consultations') }}">
                            <i class="fas fa-calendar me-2"></i>My Consultations
                        </a>
                        <a class="nav-link {{ request()->routeIs('payment.history') ? 'active' : '' }}" 
                           href="{{ route('payment.history') }}">
                            <i class="fas fa-credit-card me-2"></i>Payments
                        </a>
                        <a class="nav-link {{ request()->routeIs('review.my-reviews') ? 'active' : '' }}" 
                           href="{{ route('review.my-reviews') }}">
                            <i class="fas fa-star me-2"></i>My Reviews
                        </a>
                    @endif
                    
                    <hr class="my-3" style="border-color: rgba(255,255,255,0.2);">
                    
                    <form method="POST" action="{{ route('logout') }}" class="nav-item">
                        @csrf
                        <button type="submit" class="nav-link btn btn-link text-start w-100 text-white-50">
                            <i class="fas fa-sign-out-alt me-2"></i>Logout
                        </button>
                    </form>
                </nav>
            </div>
        </div>
        @endif

        <!-- Main Content -->
        <div class="main-content flex-fill">
            <!-- Top Navigation -->
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
                <div class="container-fluid">
                    @if(!auth()->check())
                        <a class="navbar-brand" href="{{ route('home') }}">
                            <i class="fas fa-hospital-user me-2"></i>
                            MEDEX
                        </a>
                    @else
                        <!-- Mobile menu toggle -->
                        <button class="navbar-toggler d-md-none" type="button" data-bs-toggle="offcanvas" 
                                data-bs-target="#mobileMenu">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        
                        <div class="navbar-brand d-md-none">
                            <i class="fas fa-hospital-user me-2"></i>
                            MEDEX
                        </div>
                    @endif

                    <div class="navbar-nav ms-auto">
                        @guest
                            <div class="nav-item">
                                <a class="nav-link" href="{{ route('login') }}">Login</a>
                            </div>
                            <div class="nav-item">
                                <a class="nav-link" href="{{ route('register') }}">Register</a>
                            </div>
                        @else
                            <!-- User dropdown -->
                            <div class="dropdown">
                                <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" 
                                   role="button" data-bs-toggle="dropdown">
                                    <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center me-2" 
                                         style="width: 32px; height: 32px;">
                                        <span class="text-white small">{{ substr(auth()->user()->name, 0, 1) }}</span>
                                    </div>
                                    {{ auth()->user()->name }}
                                </a>
                                <ul class="dropdown-menu dropdown-menu-end">
                                    <li>
                                        <span class="dropdown-item-text">
                                            <strong>{{ auth()->user()->name }}</strong><br>
                                            <small class="text-muted">{{ ucfirst(auth()->user()->user_type) }}</small>
                                        </span>
                                    </li>
                                    <li><hr class="dropdown-divider"></li>
                                    @if(auth()->user()->user_type === 'professional')
                                        <li><a class="dropdown-item" href="{{ route('professional.profile') }}">
                                            <i class="fas fa-user me-2"></i>Profile</a></li>
                                    @elseif(auth()->user()->user_type === 'client')
                                        <li><a class="dropdown-item" href="{{ route('client.profile') }}">
                                            <i class="fas fa-user me-2"></i>Profile</a></li>
                                    @endif
                                    <li><hr class="dropdown-divider"></li>
                                    <li>
                                        <form method="POST" action="{{ route('logout') }}">
                                            @csrf
                                            <button type="submit" class="dropdown-item">
                                                <i class="fas fa-sign-out-alt me-2"></i>Logout
                                            </button>
                                        </form>
                                    </li>
                                </ul>
                            </div>
                        @endguest
                    </div>
                </div>
            </nav>

            <!-- Flash Messages -->
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show mx-3 mt-3" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    {{ session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show mx-3 mt-3" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    {{ session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('warning'))
                <div class="alert alert-warning alert-dismissible fade show mx-3 mt-3" role="alert">
                    <i class="fas fa-exclamation-triangle me-2"></i>
                    {{ session('warning') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('info'))
                <div class="alert alert-info alert-dismissible fade show mx-3 mt-3" role="alert">
                    <i class="fas fa-info-circle me-2"></i>
                    {{ session('info') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            <!-- Page Content -->
            <main>
                @yield('content')
            </main>
        </div>
    </div>

    <!-- Mobile Offcanvas Menu -->
    @if(auth()->check())
    <div class="offcanvas offcanvas-start d-md-none" tabindex="-1" id="mobileMenu">
        <div class="offcanvas-header sidebar text-white">
            <h5 class="offcanvas-title">
                <i class="fas fa-hospital-user me-2"></i>
                MEDEX
            </h5>
            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="offcanvas"></button>
        </div>
        <div class="offcanvas-body sidebar p-0">
            <nav class="nav flex-column p-3">
                <!-- Same navigation items as sidebar -->
                @if(auth()->user()->user_type === 'admin')
                    <a class="nav-link" href="{{ route('admin.dashboard') }}">
                        <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                    </a>
                    <!-- Add other admin links -->
                @elseif(auth()->user()->user_type === 'professional')
                    <a class="nav-link" href="{{ route('professional.dashboard') }}">
                        <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                    </a>
                    <!-- Add other professional links -->
                @elseif(auth()->user()->user_type === 'client')
                    <a class="nav-link" href="{{ route('client.dashboard') }}">
                        <i class="fas fa-tachometer-alt me-2"></i>Dashboard
                    </a>
                    <!-- Add other client links -->
                @endif
            </nav>
        </div>
    </div>
    @endif

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Custom Scripts -->
    @stack('scripts')
</body>
</html>