@extends('layouts.app')

@section('title', 'Client Dashboard')

@section('content')
<div class="container-fluid mt-4">
    <!-- Welcome Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Hello, {{ auth()->user()->name }}! 👋</h2>
                    <p class="text-muted mb-0">Manage your consultations and health journey</p>
                </div>
                <div class="d-flex gap-2">
                    <a href="{{ route('client.professionals') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>Book Consultation
                    </a>
                    <button class="btn btn-outline-primary" onclick="refreshDashboard()">
                        <i class="fas fa-sync-alt me-1"></i>Refresh
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Actions Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-primary text-white h-100 action-card" onclick="location.href='{{ route('client.professionals') }}'">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-search fa-2x"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Find Professionals</h6>
                        <small>Browse and book consultations</small>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-success text-white h-100 action-card" onclick="location.href='{{ route('client.consultations') }}'">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-calendar-check fa-2x"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">My Consultations</h6>
                        <small>View past and upcoming</small>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-info text-white h-100 action-card" onclick="location.href='{{ route('payment.history') }}'">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-credit-card fa-2x"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">Payment History</h6>
                        <small>Track your payments</small>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-warning text-white h-100 action-card" onclick="location.href='{{ route('review.my-reviews') }}'">
                <div class="card-body d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-star fa-2x"></i>
                    </div>
                    <div>
                        <h6 class="mb-1">My Reviews</h6>
                        <small>Reviews you've given</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Summary Statistics -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="text-primary mb-2">{{ $stats['total_consultations'] ?? 0 }}</h3>
                    <p class="text-muted mb-0">Total Consultations</p>
                    @if(($stats['consultations_growth'] ?? 0) != 0)
                        <small class="text-{{ ($stats['consultations_growth'] ?? 0) > 0 ? 'success' : 'danger' }}">
                            <i class="fas fa-arrow-{{ ($stats['consultations_growth'] ?? 0) > 0 ? 'up' : 'down' }} me-1"></i>
                            {{ abs($stats['consultations_growth'] ?? 0) }}% from last month
                        </small>
                    @endif
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="text-success mb-2">₹{{ number_format($stats['total_spent'] ?? 0) }}</h3>
                    <p class="text-muted mb-0">Total Spent</p>
                    <small class="text-muted">₹{{ number_format($stats['spent_this_month'] ?? 0) }} this month</small>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="text-warning mb-2">{{ $stats['favorite_professionals'] ?? 0 }}</h3>
                    <p class="text-muted mb-0">Favorite Professionals</p>
                    <small class="text-muted">Based on repeat bookings</small>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card text-center">
                <div class="card-body">
                    <h3 class="text-info mb-2">{{ $stats['pending_reviews'] ?? 0 }}</h3>
                    <p class="text-muted mb-0">Pending Reviews</p>
                    <small class="text-muted">Consultations to review</small>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Main Content -->
        <div class="col-lg-8">
            <!-- Upcoming Consultations -->
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-calendar-alt me-2"></i>
                        Upcoming Consultations
                    </h5>
                    <a href="{{ route('client.consultations') }}" class="btn btn-outline-primary btn-sm">
                        View All
                    </a>
                </div>
                <div class="card-body p-0">
                    @if(isset($upcomingConsultations) && count($upcomingConsultations) > 0)
                        <div class="list-group list-group-flush">
                            @foreach($upcomingConsultations as $consultation)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                            <div class="consultation-date me-3">
                                                <div class="date-box text-center p-2 bg-light rounded">
                                                    <div class="fs-4 fw-bold text-primary">{{ $consultation->scheduled_at->format('d') }}</div>
                                                    <small class="text-muted">{{ $consultation->scheduled_at->format('M') }}</small>
                                                </div>
                                            </div>
                                            <div class="consultation-info">
                                                <h6 class="mb-1">Dr. {{ $consultation->professional->user->name }}</h6>
                                                <p class="mb-1 text-muted">{{ $consultation->professional->specialty }}</p>
                                                <div class="consultation-details">
                                                    <small class="text-muted">
                                                        <i class="fas fa-clock me-1"></i>
                                                        {{ $consultation->scheduled_at->format('h:i A') }}
                                                    </small>
                                                    <small class="text-muted ms-3">
                                                        <i class="fas fa-hourglass-half me-1"></i>
                                                        {{ $consultation->duration }} minutes
                                                    </small>
                                                    <span class="badge bg-{{ $consultation->consultation_type === 'video' ? 'primary' : 'success' }} ms-2">
                                                        {{ ucfirst($consultation->consultation_type) }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="consultation-actions">
                                            @if($consultation->scheduled_at <= now()->addMinutes(15))
                                                <a href="{{ route('consultation.meeting', $consultation) }}" class="btn btn-success">
                                                    <i class="fas fa-video me-1"></i>Join Now
                                                </a>
                                            @else
                                                <div class="text-end">
                                                    <p class="mb-0 text-muted small">
                                                        Starts {{ $consultation->scheduled_at->diffForHumans() }}
                                                    </p>
                                                    <a href="{{ route('consultation.show', $consultation) }}" class="btn btn-outline-primary btn-sm">
                                                        View Details
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-calendar-plus fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No upcoming consultations</h5>
                            <p class="text-muted">Book your first consultation to get started</p>
                            <a href="{{ route('client.professionals') }}" class="btn btn-primary">
                                <i class="fas fa-search me-1"></i>Find Professionals
                            </a>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Recent Consultations -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="fas fa-history me-2"></i>
                        Recent Consultations
                    </h5>
                    <a href="{{ route('client.consultations') }}" class="btn btn-outline-primary btn-sm">
                        View All
                    </a>
                </div>
                <div class="card-body p-0">
                    @if(isset($recentConsultations) && count($recentConsultations) > 0)
                        <div class="list-group list-group-flush">
                            @foreach($recentConsultations as $consultation)
                                <div class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex align-items-start">
                                            <div class="me-3">
                                                <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                                     style="width: 50px; height: 50px;">
                                                    <span class="text-white">{{ substr($consultation->professional->user->name, 0, 1) }}</span>
                                                </div>
                                            </div>
                                            <div>
                                                <h6 class="mb-1">Dr. {{ $consultation->professional->user->name }}</h6>
                                                <p class="mb-1 text-muted">{{ $consultation->professional->specialty }}</p>
                                                <div class="consultation-meta">
                                                    <small class="text-muted">
                                                        <i class="fas fa-calendar me-1"></i>
                                                        {{ $consultation->scheduled_at->format('M d, Y') }}
                                                    </small>
                                                    <small class="text-muted ms-3">
                                                        <i class="fas fa-clock me-1"></i>
                                                        {{ $consultation->duration }} minutes
                                                    </small>
                                                    <span class="badge bg-{{ $consultation->status === 'completed' ? 'success' : 'warning' }} ms-2">
                                                        {{ ucfirst($consultation->status) }}
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="consultation-actions text-end">
                                            @if($consultation->status === 'completed' && !$consultation->review)
                                                <a href="{{ route('review.create', $consultation) }}" class="btn btn-outline-warning btn-sm mb-1">
                                                    <i class="fas fa-star me-1"></i>Write Review
                                                </a>
                                            @endif
                                            <a href="{{ route('consultation.show', $consultation) }}" class="btn btn-outline-primary btn-sm">
                                                <i class="fas fa-eye me-1"></i>View Details
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="fas fa-user-md fa-3x text-muted mb-3"></i>
                            <h5 class="text-muted">No consultations yet</h5>
                            <p class="text-muted">Your consultation history will appear here</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Right Sidebar -->
        <div class="col-lg-4">
            <!-- Health Tips -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-lightbulb me-2"></i>
                        Health Tips
                    </h6>
                </div>
                <div class="card-body">
                    <div class="tips-container">
                        @php
                            $healthTips = [
                                'Stay hydrated by drinking at least 8 glasses of water daily',
                                'Get 7-9 hours of quality sleep for better health',
                                'Take regular breaks from screen time to protect your eyes',
                                'Practice deep breathing for stress management',
                                'Maintain good posture while working'
                            ];
                            $randomTip = $healthTips[array_rand($healthTips)];
                        @endphp
                        <div class="tip-of-day p-3 bg-light rounded">
                            <h6 class="text-primary mb-2">💡 Tip of the Day</h6>
                            <p class="mb-0">{{ $randomTip }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Favorite Professionals -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-heart me-2"></i>
                        Favorite Professionals
                    </h6>
                </div>
                <div class="card-body">
                    @if(isset($favoriteProfessionals) && count($favoriteProfessionals) > 0)
                        <div class="favorite-professionals">
                            @foreach($favoriteProfessionals as $professional)
                                <div class="d-flex align-items-center mb-3">
                                    <div class="me-3">
                                        <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center" 
                                             style="width: 40px; height: 40px;">
                                            <span class="text-white small">{{ substr($professional->user->name, 0, 1) }}</span>
                                        </div>
                                    </div>
                                    <div class="flex-fill">
                                        <h6 class="mb-0">Dr. {{ $professional->user->name }}</h6>
                                        <small class="text-muted">{{ $professional->specialty }}</small>
                                        <div class="rating">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star {{ $i <= $professional->average_rating ? 'text-warning' : 'text-light' }} small"></i>
                                            @endfor
                                        </div>
                                    </div>
                                    <a href="{{ route('client.book', $professional) }}" class="btn btn-outline-primary btn-sm">
                                        <i class="fas fa-calendar-plus"></i>
                                    </a>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-3">
                            <i class="fas fa-heart fa-2x text-muted mb-2"></i>
                            <p class="text-muted mb-0">No favorites yet</p>
                            <small class="text-muted">Book consultations to add favorites</small>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">
                        <i class="fas fa-bolt me-2"></i>
                        Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('client.professionals') }}" class="btn btn-primary">
                            <i class="fas fa-search me-2"></i>Find Professionals
                        </a>
                        <a href="{{ route('client.profile') }}" class="btn btn-outline-primary">
                            <i class="fas fa-user-edit me-2"></i>Update Profile
                        </a>
                        <a href="{{ route('payment.history') }}" class="btn btn-outline-secondary">
                            <i class="fas fa-file-invoice me-2"></i>Payment History
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.bg-gradient-primary {
    background: linear-gradient(87deg, #5e72e4 0, #825ee4 100%);
}

.bg-gradient-success {
    background: linear-gradient(87deg, #2dce89 0, #2dcecc 100%);
}

.bg-gradient-info {
    background: linear-gradient(87deg, #11cdef 0, #1171ef 100%);
}

.bg-gradient-warning {
    background: linear-gradient(87deg, #fb6340 0, #fbb140 100%);
}

.action-card {
    cursor: pointer;
    transition: transform 0.2s, box-shadow 0.2s;
}

.action-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 0.5rem 2rem 0 rgba(136, 152, 170, 0.15);
}

.date-box {
    min-width: 60px;
}

.consultation-date {
    min-width: 80px;
}

.tip-of-day {
    border-left: 4px solid #5e72e4;
}

.card {
    border: none;
    box-shadow: 0 0 2rem 0 rgba(136, 152, 170, 0.15);
    transition: transform 0.2s;
}

.card:hover {
    transform: translateY(-2px);
}

.rating {
    font-size: 0.8rem;
}

@media (max-width: 768px) {
    .consultation-actions {
        margin-top: 10px;
        text-align: left !important;
    }
    
    .action-card {
        margin-bottom: 15px;
    }
}
</style>
@endpush

@push('scripts')
<script>
function refreshDashboard() {
    window.location.reload();
}

// Auto-refresh tips
setInterval(function() {
    // Could rotate health tips here
    console.log('Dashboard active...');
}, 30000);

// Add click handlers for action cards
document.querySelectorAll('.action-card').forEach(card => {
    card.addEventListener('click', function() {
        if (this.onclick) {
            this.onclick();
        }
    });
});
</script>
@endpush
@endsection