@extends('layouts.app')

@section('title', 'Admin Dashboard')

@section('content')
<div class="container-fluid mt-4">
    <!-- Dashboard Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="mb-1">Admin Dashboard</h2>
                    <p class="text-muted mb-0">Overview of platform activities and management</p>
                </div>
                <div class="d-flex gap-2">
                    <button class="btn btn-outline-primary" onclick="refreshDashboard()">
                        <i class="fas fa-sync-alt me-1"></i>Refresh
                    </button>
                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="fas fa-download me-1"></i>Export
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#"><i class="fas fa-file-excel me-2"></i>Excel Report</a></li>
                            <li><a class="dropdown-item" href="#"><i class="fas fa-file-pdf me-2"></i>PDF Report</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Key Metrics Cards -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-primary text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">Total Users</h6>
                            <h2 class="mb-0">{{ $stats['total_users'] ?? 0 }}</h2>
                            <small class="text-white-50">
                                <i class="fas fa-arrow-up me-1"></i>
                                +{{ $stats['new_users_this_month'] ?? 0 }} this month
                            </small>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-users fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-success text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">Active Professionals</h6>
                            <h2 class="mb-0">{{ $stats['active_professionals'] ?? 0 }}</h2>
                            <small class="text-white-50">
                                {{ $stats['verified_professionals'] ?? 0 }} verified
                            </small>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-user-tie fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-info text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">Total Consultations</h6>
                            <h2 class="mb-0">{{ $stats['total_consultations'] ?? 0 }}</h2>
                            <small class="text-white-50">
                                {{ $stats['consultations_this_month'] ?? 0 }} this month
                            </small>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-calendar-check fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card bg-gradient-warning text-white h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="card-title text-white-50">Revenue</h6>
                            <h2 class="mb-0">₹{{ number_format($stats['total_revenue'] ?? 0) }}</h2>
                            <small class="text-white-50">
                                ₹{{ number_format($stats['revenue_this_month'] ?? 0) }} this month
                            </small>
                        </div>
                        <div class="text-white-50">
                            <i class="fas fa-rupee-sign fa-2x"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Charts Section -->
        <div class="col-lg-8">
            <!-- Revenue Chart -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Revenue Analytics</h5>
                    <div class="card-tools">
                        <select class="form-select form-select-sm" id="revenueFilter">
                            <option value="7days">Last 7 Days</option>
                            <option value="30days" selected>Last 30 Days</option>
                            <option value="90days">Last 90 Days</option>
                            <option value="1year">Last Year</option>
                        </select>
                    </div>
                </div>
                <div class="card-body">
                    <canvas id="revenueChart" height="300"></canvas>
                </div>
            </div>

            <!-- Consultations Chart -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Consultation Trends</h5>
                </div>
                <div class="card-body">
                    <canvas id="consultationChart" height="250"></canvas>
                </div>
            </div>
        </div>

        <!-- Right Sidebar -->
        <div class="col-lg-4">
            <!-- Recent Activities -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Recent Activities</h6>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @if(isset($recentActivities) && count($recentActivities) > 0)
                            @foreach($recentActivities as $activity)
                                <div class="list-group-item">
                                    <div class="d-flex align-items-center">
                                        <div class="activity-icon me-3">
                                            <i class="fas fa-{{ $activity['icon'] }} text-{{ $activity['color'] }}"></i>
                                        </div>
                                        <div class="flex-fill">
                                            <p class="mb-1 small">{{ $activity['description'] }}</p>
                                            <small class="text-muted">{{ $activity['time'] }}</small>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="list-group-item text-center text-muted py-4">
                                <i class="fas fa-clock fa-2x mb-2"></i>
                                <p class="mb-0">No recent activities</p>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="card-footer">
                    <a href="#" class="btn btn-outline-primary btn-sm w-100" onclick="alert('Activities page coming soon!')">
                        View All Activities
                    </a>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="card mb-4">
                <div class="card-header">
                    <h6 class="mb-0">Quick Stats</h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-6 mb-3">
                            <h4 class="text-success mb-0">{{ $stats['active_subscriptions'] ?? 0 }}</h4>
                            <small class="text-muted">Active Subscriptions</small>
                        </div>
                        <div class="col-6 mb-3">
                            <h4 class="text-info mb-0">{{ number_format($stats['average_rating'] ?? 0, 1) }}</h4>
                            <small class="text-muted">Avg Rating</small>
                        </div>
                        <div class="col-6">
                            <h4 class="text-warning mb-0">{{ $stats['pending_approvals'] ?? 0 }}</h4>
                            <small class="text-muted">Pending Approvals</small>
                        </div>
                        <div class="col-6">
                            <h4 class="text-danger mb-0">{{ $stats['reported_reviews'] ?? 0 }}</h4>
                            <small class="text-muted">Reported Reviews</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Top Professionals -->
            <div class="card">
                <div class="card-header">
                    <h6 class="mb-0">Top Professionals</h6>
                </div>
                <div class="card-body p-0">
                    <div class="list-group list-group-flush">
                        @if(isset($topProfessionals) && count($topProfessionals) > 0)
                            @foreach($topProfessionals as $index => $professional)
                                <div class="list-group-item">
                                    <div class="d-flex align-items-center">
                                        <div class="rank-badge me-3">
                                            <span class="badge bg-{{ $index < 3 ? ['warning', 'secondary', 'warning'][$index] : 'light' }}">
                                                #{{ $index + 1 }}
                                            </span>
                                        </div>
                                        <div class="flex-fill">
                                            <p class="mb-1 fw-bold">{{ $professional['name'] }}</p>
                                            <small class="text-muted">{{ $professional['specialty'] }} • ₹{{ number_format($professional['earnings']) }}</small>
                                        </div>
                                        <div class="rating">
                                            <span class="badge bg-success">{{ $professional['rating'] }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="list-group-item text-center text-muted py-4">
                                <i class="fas fa-trophy fa-2x mb-2"></i>
                                <p class="mb-0">No data available</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Management Actions -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Quick Management Actions</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('admin.professionals') }}" class="btn btn-outline-primary w-100">
                                <i class="fas fa-user-check me-2"></i>
                                Manage Professionals
                                @if(($stats['pending_approvals'] ?? 0) > 0)
                                    <span class="badge bg-danger ms-2">{{ $stats['pending_approvals'] }}</span>
                                @endif
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('admin.reviews.index') }}" class="btn btn-outline-warning w-100">
                                <i class="fas fa-flag me-2"></i>
                                Review Reports
                                @if(($stats['reported_reviews'] ?? 0) > 0)
                                    <span class="badge bg-danger ms-2">{{ $stats['reported_reviews'] }}</span>
                                @endif
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('admin.payments') }}" class="btn btn-outline-success w-100">
                                <i class="fas fa-credit-card me-2"></i>
                                Payment Management
                            </a>
                        </div>
                        <div class="col-md-3 mb-3">
                            <a href="{{ route('admin.subscription-plans') }}" class="btn btn-outline-info w-100">
                                <i class="fas fa-crown me-2"></i>
                                Subscription Plans
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.bg-gradient-primary {
    background: linear-gradient(87deg, #5e72e4 0, #825ee4 100%);
}

.bg-gradient-success {
    background: linear-gradient(87deg, #2dce89 0, #2dcecc 100%);
}

.bg-gradient-info {
    background: linear-gradient(87deg, #11cdef 0, #1171ef 100%);
}

.bg-gradient-warning {
    background: linear-gradient(87deg, #fb6340 0, #fbb140 100%);
}

.card {
    box-shadow: 0 0 2rem 0 rgba(136, 152, 170, 0.15);
    border: none;
}

.card-tools {
    position: absolute;
    right: 1rem;
    top: 1rem;
}

.activity-icon {
    width: 35px;
    height: 35px;
    border-radius: 50%;
    background-color: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
}

.rank-badge .badge {
    font-size: 0.75rem;
}

@media (max-width: 768px) {
    .card-tools {
        position: static;
        margin-top: 10px;
    }
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Revenue Chart
const revenueCtx = document.getElementById('revenueChart').getContext('2d');
const revenueChart = new Chart(revenueCtx, {
    type: 'line',
    data: {
        labels: @json($chartData['revenue']['labels'] ?? ['No Data']),
        datasets: [{
            label: 'Revenue (₹)',
            data: @json($chartData['revenue']['data'] ?? [0]),
            borderColor: '#5e72e4',
            backgroundColor: 'rgba(94, 114, 228, 0.1)',
            tension: 0.4,
            fill: true
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: function(value) {
                        return '₹' + value.toLocaleString();
                    }
                }
            }
        }
    }
});

// Consultation Chart
const consultationCtx = document.getElementById('consultationChart').getContext('2d');
const consultationChart = new Chart(consultationCtx, {
    type: 'bar',
    data: {
        labels: @json($chartData['consultations']['labels'] ?? ['No Data']),
        datasets: [{
            label: 'Consultations',
            data: @json($chartData['consultations']['data'] ?? [0]),
            backgroundColor: '#2dce89',
            borderRadius: 4
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

function refreshDashboard() {
    window.location.reload();
}

// Revenue filter change
document.getElementById('revenueFilter').addEventListener('change', function() {
    // In a real application, this would make an AJAX call to update the chart
    console.log('Filter changed to:', this.value);
});
</script>
@endpush
@endsection