@extends('layouts.app')

@section('title', 'Manage Consultations')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Manage Consultations</h5>
                </div>
                <div class="card-body">
                    <!-- Search Form -->
                    <form method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-4">
                                <input type="text" name="search" class="form-control" placeholder="Search consultations..." value="{{ request('search') }}">
                            </div>
                            <div class="col-md-3">
                                <select name="status" class="form-control">
                                    <option value="">All Status</option>
                                    <option value="scheduled" {{ request('status') == 'scheduled' ? 'selected' : '' }}>Scheduled</option>
                                    <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>In Progress</option>
                                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <input type="date" name="date" class="form-control" value="{{ request('date') }}">
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-primary">Filter</button>
                            </div>
                        </div>
                    </form>

                    <!-- Consultations Table -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Client</th>
                                    <th>Professional</th>
                                    <th>Scheduled</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($consultations as $consultation)
                                <tr>
                                    <td>#{{ $consultation->id }}</td>
                                    <td>{{ $consultation->client->user->name ?? 'N/A' }}</td>
                                    <td>{{ $consultation->professional->user->name ?? 'N/A' }}</td>
                                    <td>{{ $consultation->scheduled_at ? $consultation->scheduled_at->format('M d, Y h:i A') : 'N/A' }}</td>
                                    <td>{{ ucfirst($consultation->consultation_type ?? 'N/A') }}</td>
                                    <td>₹{{ number_format($consultation->total_amount ?? 0, 2) }}</td>
                                    <td>
                                        <span class="badge badge-{{ $consultation->status == 'completed' ? 'success' : ($consultation->status == 'cancelled' ? 'danger' : 'primary') }}">
                                            {{ ucfirst($consultation->status ?? 'Unknown') }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('consultation.show', $consultation) }}" class="btn btn-sm btn-info">View</a>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center">No consultations found</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $consultations->appends(request()->query())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection