<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SubscriptionPlanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $plans = [
            [
                'name' => 'Silver',
                'slug' => 'silver',
                'description' => 'Basic listing with standard features',
                'monthly_price' => 999.00,
                'yearly_price' => 9999.00,
                'commission_percentage' => 40, // Platform takes 40%, professional gets 60%
                'features' => json_encode([
                    'Basic listing',
                    'Limited support',
                    'Standard search visibility',
                    'Basic analytics'
                ]),
                'max_consultations_per_month' => 50,
                'priority_listing' => false,
                'featured_profile' => false,
                'dedicated_support' => false,
                'is_active' => true,
                'sort_order' => 1,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Gold',
                'slug' => 'gold',
                'description' => 'Enhanced listing with priority features',
                'monthly_price' => 1999.00,
                'yearly_price' => 19999.00,
                'commission_percentage' => 25, // Platform takes 25%, professional gets 75%
                'features' => json_encode([
                    'Priority listing',
                    'Enhanced support',
                    'Higher search visibility',
                    'Advanced analytics',
                    'Faster payouts',
                    'Custom consultation hours'
                ]),
                'max_consultations_per_month' => 150,
                'priority_listing' => true,
                'featured_profile' => false,
                'dedicated_support' => false,
                'is_active' => true,
                'sort_order' => 2,
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'name' => 'Platinum',
                'slug' => 'platinum',
                'description' => 'Premium listing with all features',
                'monthly_price' => 4999.00,
                'yearly_price' => 49999.00,
                'commission_percentage' => 10, // Platform takes 10%, professional gets 90%
                'features' => json_encode([
                    'Premium listing',
                    'Top search visibility',
                    'Featured profile badge',
                    'Dedicated support manager',
                    'Instant payouts',
                    'Custom branding options',
                    'Advanced analytics & reports',
                    'Unlimited consultations'
                ]),
                'max_consultations_per_month' => null, // Unlimited
                'priority_listing' => true,
                'featured_profile' => true,
                'dedicated_support' => true,
                'is_active' => true,
                'sort_order' => 3,
                'created_at' => now(),
                'updated_at' => now(),
            ]
        ];

        DB::table('subscription_plans')->insert($plans);
    }
}
