<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        $this->call([
            SubscriptionPlanSeeder::class,
            AdminSeeder::class,
        ]);

        // Create default admin user
        User::factory()->create([
            'name' => 'Admin User',
            'email' => 'admin@medex.com',
            'user_type' => 'admin',
            'status' => 'active',
        ]);

        // Create test users
        User::factory()->create([
            'name' => 'Test Professional',
            'email' => 'professional@medex.com',
            'user_type' => 'professional',
            'status' => 'active',
        ]);

        User::factory()->create([
            'name' => 'Test Client',
            'email' => 'client@medex.com',
            'user_type' => 'client',
            'status' => 'active',
        ]);
    }
}
