<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create admin user
        $admin = User::create([
            'name' => 'Admin User',
            'email' => 'admin@medex.com',
            'password' => Hash::make('admin123'),
            'phone' => '9999999999',
            'user_type' => 'admin',
            'email_verified_at' => now(),
        ]);

        // Create a test professional
        $professional = User::create([
            'name' => 'Dr. Sarah Johnson',
            'email' => 'professional@medex.com',
            'password' => Hash::make('professional123'),
            'phone' => '9876543210',
            'user_type' => 'professional',
            'email_verified_at' => now(),
        ]);

        // Create professional profile
        $professional->professional()->create([
            'profession_type' => 'advocate',
            'license_number' => 'LEG2024001',
            'experience_years' => 10,
            'consultation_fee' => 2000,
            'specializations' => ['Medical Law', 'Healthcare Compliance', 'Insurance Claims'],
            'office_address' => '123 Legal Plaza, Medical District',
            'city' => 'Mumbai',
            'state' => 'Maharashtra',
            'pincode' => '400001',
            'verification_status' => 'verified',
            'verified_at' => now(),
        ]);

        // Create a test client
        $client = User::create([
            'name' => 'Dr. Raj Patel',
            'email' => 'client@medex.com',
            'password' => Hash::make('client123'),
            'phone' => '9876543211',
            'user_type' => 'client',
            'email_verified_at' => now(),
        ]);

        // Create client profile
        $client->client()->create([
            'profession_type' => 'doctor',
            'clinic_hospital_name' => 'City General Hospital',
            'medical_license' => 'MED2024001',
            'address' => '456 Hospital Road, Health City',
            'city' => 'Delhi',
            'state' => 'Delhi',
            'pincode' => '110001',
            'verification_status' => 'verified',
            'verified_at' => now(),
        ]);

        $this->command->info('Default users created successfully:');
        $this->command->info('Admin: admin@medex.com / admin123');
        $this->command->info('Professional: professional@medex.com / professional123');
        $this->command->info('Client: client@medex.com / client123');
    }
}