<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payouts', function (Blueprint $table) {
            $table->id();
            $table->string('payout_id')->unique();
            $table->foreignId('professional_id')->constrained('professionals');
            $table->decimal('amount', 10, 2);
            $table->decimal('tds_amount', 8, 2)->default(0); // Tax Deducted at Source
            $table->decimal('net_amount', 10, 2);
            $table->enum('status', ['requested', 'processing', 'completed', 'failed', 'cancelled']);
            $table->date('request_date');
            $table->date('processed_date')->nullable();
            $table->string('bank_account_number');
            $table->string('bank_ifsc');
            $table->string('bank_name');
            $table->string('account_holder_name');
            $table->string('transaction_reference')->nullable();
            $table->text('notes')->nullable();
            $table->foreignId('processed_by')->nullable()->constrained('users');
            $table->json('commission_ids')->nullable(); // Array of commission IDs included
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payouts');
    }
};
