<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Consultation extends Model
{
    use HasFactory;

    protected $fillable = [
        'consultation_id',
        'client_id',
        'professional_id',
        'consultation_type',
        'scheduled_at',
        'started_at',
        'ended_at',
        'duration_minutes',
        'status',
        'consultation_fee',
        'platform_fee',
        'gst_amount',
        'total_amount',
        'meeting_id',
        'meeting_url',
        'consultation_notes',
        'client_notes',
        'documents',
        'invoice_number',
        'cancelled_at',
        'cancellation_reason',
        'cancelled_by',
    ];

    protected $casts = [
        'scheduled_at' => 'datetime',
        'started_at' => 'datetime',
        'ended_at' => 'datetime',
        'cancelled_at' => 'datetime',
        'documents' => 'array',
        'consultation_fee' => 'decimal:2',
        'platform_fee' => 'decimal:2',
        'gst_amount' => 'decimal:2',
        'total_amount' => 'decimal:2',
    ];

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function professional()
    {
        return $this->belongsTo(Professional::class);
    }

    public function payment()
    {
        return $this->morphOne(Payment::class, 'payable');
    }

    public function commission()
    {
        return $this->hasOne(Commission::class);
    }

    public function reviews()
    {
        return $this->hasMany(Review::class);
    }
}
