<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Client extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'profession_type',
        'medical_license',
        'clinic_hospital_name',
        'address',
        'city',
        'state',
        'pincode',
        'verification_status',
        'verified_at',
        'total_consultations',
    ];

    protected $casts = [
        'verified_at' => 'datetime',
    ];

    /**
     * Get the user that owns the client profile
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get consultations for this client
     */
    public function consultations()
    {
        return $this->hasMany(Consultation::class);
    }

    /**
     * Get payments made by this client
     */
    public function payments()
    {
        return $this->hasManyThrough(Payment::class, Consultation::class, 'client_id', 'payable_id')
                    ->where('payable_type', Consultation::class);
    }

    /**
     * Scope for verified clients
     */
    public function scopeVerified($query)
    {
        return $query->where('verification_status', 'verified');
    }
}
